/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.hudson.plugins.copytoslave;

import com.michelin.cio.hudson.plugins.copytoslave.CopyToSlaveUtils;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Hudson;
import hudson.slaves.SlaveComputer;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import java.io.IOException;
import java.io.PrintStream;
import org.kohsuke.stapler.DataBoundConstructor;

public class CopyToMasterNotifier
extends Notifier {
    private final String includes;
    private final String excludes;

    @DataBoundConstructor
    public CopyToMasterNotifier(String includes, String excludes) {
        this.includes = includes;
        this.excludes = excludes;
    }

    public boolean needsToRunAfterFinalized() {
        return true;
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        if (Computer.currentComputer() instanceof SlaveComputer) {
            FilePath projectWorkspaceOnMaster = CopyToSlaveUtils.getProjectWorkspaceOnMaster((AbstractBuild)build, (PrintStream)listener.getLogger());
            FilePath projectWorkspaceOnSlave = build.getProject().getWorkspace();
            listener.getLogger().printf("Copying '%s', excluding '%s' from '%s' on '%s' to '%s' on the master.\n", this.getIncludes(), this.getExcludes(), projectWorkspaceOnSlave.toURI(), Computer.currentComputer().getNode(), projectWorkspaceOnMaster.toURI());
            CopyToSlaveUtils.hudson5977((FilePath)projectWorkspaceOnSlave);
            projectWorkspaceOnSlave.copyRecursiveTo(this.getIncludes(), this.getExcludes(), projectWorkspaceOnMaster);
        } else if (Computer.currentComputer() instanceof Hudson.MasterComputer) {
            listener.getLogger().println("The build is taking place on the master node, no copy back to the master will take place.");
        }
        return true;
    }

    public String getIncludes() {
        return this.includes;
    }

    public String getExcludes() {
        return this.excludes;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }
}

