/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.hudson.plugins.copytoslave;

import com.michelin.cio.hudson.plugins.copytoslave.CopyToSlaveUtils;
import com.michelin.cio.hudson.plugins.copytoslave.MyFilePath;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.Build;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Hudson;
import hudson.slaves.SlaveComputer;
import hudson.tasks.BuildWrapper;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class CopyToSlaveBuildWrapper
extends BuildWrapper {
    private final String includes;
    private final String excludes;
    private final boolean flatten;
    private final boolean includeAntExcludes;
    private final boolean hudsonHomeRelative;

    @DataBoundConstructor
    public CopyToSlaveBuildWrapper(String includes, String excludes, boolean flatten, boolean includeAntExcludes, boolean hudsonHomeRelative) {
        this.includes = includes;
        this.excludes = excludes;
        this.flatten = flatten;
        this.includeAntExcludes = includeAntExcludes;
        this.hudsonHomeRelative = hudsonHomeRelative;
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        if (StringUtils.isBlank((String)this.getIncludes())) {
            listener.fatalError("No includes have been defined for the \"Copy files to slave node before building\" option: It is mandatory to define them.");
            return null;
        }
        if (Computer.currentComputer() instanceof SlaveComputer) {
            FilePath rootFilePathOnMaster = !this.isHudsonHomeRelative() ? CopyToSlaveUtils.getProjectWorkspaceOnMaster((AbstractBuild)build, (PrintStream)listener.getLogger()) : Hudson.getInstance().getRootPath();
            FilePath projectWorkspaceOnSlave = build.getProject().getWorkspace();
            listener.getLogger().printf("Copying '%s', excluding '%s' from '%s' on the master to '%s' on '%s'.\n", this.getIncludes(), this.getExcludes(), rootFilePathOnMaster.toURI(), projectWorkspaceOnSlave.toURI(), Computer.currentComputer().getNode().getDisplayName());
            CopyToSlaveUtils.hudson5977((FilePath)projectWorkspaceOnSlave);
            MyFilePath.copyRecursiveTo((FilePath)rootFilePathOnMaster, (String)this.getIncludes(), (String)this.getExcludes(), (boolean)this.isFlatten(), (boolean)this.isIncludeAntExcludes(), (FilePath)projectWorkspaceOnSlave);
        } else if (Computer.currentComputer() instanceof Hudson.MasterComputer) {
            listener.getLogger().println("The build is taking place on the master node, no copy to a slave node will take place.");
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public BuildWrapper.Environment setUp(Build build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        return this.setUp(build, launcher, listener);
    }

    public String getIncludes() {
        return this.includes;
    }

    public String getExcludes() {
        return this.excludes;
    }

    public boolean isIncludeAntExcludes() {
        return this.includeAntExcludes;
    }

    public boolean isFlatten() {
        return this.flatten;
    }

    public boolean isHudsonHomeRelative() {
        return this.hudsonHomeRelative;
    }
}

