/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.hudson.plugins.copytoslave;

import com.michelin.cio.hudson.plugins.copytoslave.CopyToSlaveBuildWrapper;
import com.michelin.cio.hudson.plugins.copytoslave.CopyToSlaveUtils;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Hudson;
import hudson.slaves.SlaveComputer;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import java.io.IOException;
import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class CopyToMasterNotifier
extends Notifier {
    private final String includes;
    private final String excludes;

    @DataBoundConstructor
    public CopyToMasterNotifier(String includes, String excludes) {
        this.includes = includes;
        this.excludes = excludes;
    }

    public boolean needsToRunAfterFinalized() {
        return true;
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        if (Computer.currentComputer() instanceof SlaveComputer) {
            FilePath projectWorkspaceOnMaster = CopyToSlaveUtils.getProjectWorkspaceOnMaster(build, listener.getLogger());
            FilePath projectWorkspaceOnSlave = build.getProject().getWorkspace();
            listener.getLogger().printf("Copying '%s', excluding '%s' from '%s' on '%s' to '%s' on the master.\n", this.getIncludes(), this.getExcludes(), projectWorkspaceOnSlave.toURI(), Computer.currentComputer().getNode(), projectWorkspaceOnMaster.toURI());
            CopyToSlaveUtils.hudson5977(projectWorkspaceOnSlave);
            projectWorkspaceOnSlave.copyRecursiveTo(this.getIncludes(), this.getExcludes(), projectWorkspaceOnMaster);
        } else if (Computer.currentComputer() instanceof Hudson.MasterComputer) {
            listener.getLogger().println("The build is taking place on the master node, no copy back to the master will take place.");
        }
        return true;
    }

    public String getIncludes() {
        return this.includes;
    }

    public String getExcludes() {
        return this.excludes;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public DescriptorImpl() {
            super(CopyToMasterNotifier.class);
        }

        public String getDisplayName() {
            return new Localizable(ResourceBundleHolder.get(CopyToMasterNotifier.class), "DisplayName", new Object[0]).toString();
        }

        public boolean isApplicable(Class<? extends AbstractProject> item) {
            return true;
        }

        public FormValidation doCheckIncludes(@AncestorInPath AbstractProject project, @QueryParameter String value) throws IOException {
            return CopyToSlaveBuildWrapper.DescriptorImpl.checkFile(project, value, false);
        }

        public FormValidation doCheckExcludes(@AncestorInPath AbstractProject project, @QueryParameter String value) throws IOException {
            return CopyToSlaveBuildWrapper.DescriptorImpl.checkFile(project, value, false);
        }
    }
}

