/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.hudson.plugins.copytoslave;

import com.michelin.cio.hudson.plugins.copytoslave.CopyToSlaveUtils;
import com.michelin.cio.hudson.plugins.copytoslave.MyFilePath;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Build;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Hudson;
import hudson.slaves.SlaveComputer;
import hudson.tasks.BuildWrapper;
import hudson.tasks.BuildWrapperDescriptor;
import hudson.util.FormValidation;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class CopyToSlaveBuildWrapper
extends BuildWrapper {
    private final String includes;
    private final String excludes;
    private final boolean flatten;
    private final boolean includeAntExcludes;
    private final boolean hudsonHomeRelative;

    @DataBoundConstructor
    public CopyToSlaveBuildWrapper(String includes, String excludes, boolean flatten, boolean includeAntExcludes, boolean hudsonHomeRelative) {
        this.includes = includes;
        this.excludes = excludes;
        this.flatten = flatten;
        this.includeAntExcludes = includeAntExcludes;
        this.hudsonHomeRelative = hudsonHomeRelative;
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        if (StringUtils.isBlank((String)this.getIncludes())) {
            listener.fatalError("No includes have been defined for the \"Copy files to slave node before building\" option: It is mandatory to define them.");
            return null;
        }
        if (Computer.currentComputer() instanceof SlaveComputer) {
            FilePath rootFilePathOnMaster = !this.isHudsonHomeRelative() ? CopyToSlaveUtils.getProjectWorkspaceOnMaster(build, listener.getLogger()) : Hudson.getInstance().getRootPath();
            FilePath projectWorkspaceOnSlave = build.getProject().getWorkspace();
            listener.getLogger().printf("Copying '%s', excluding '%s' from '%s' on the master to '%s' on '%s'.\n", this.getIncludes(), this.getExcludes(), rootFilePathOnMaster.toURI(), projectWorkspaceOnSlave.toURI(), Computer.currentComputer().getNode().getDisplayName());
            CopyToSlaveUtils.hudson5977(projectWorkspaceOnSlave);
            MyFilePath.copyRecursiveTo(rootFilePathOnMaster, this.getIncludes(), this.getExcludes(), this.isFlatten(), this.isIncludeAntExcludes(), projectWorkspaceOnSlave);
        } else if (Computer.currentComputer() instanceof Hudson.MasterComputer) {
            listener.getLogger().println("The build is taking place on the master node, no copy to a slave node will take place.");
        }
        return new BuildWrapper.Environment(){

            public boolean tearDown(AbstractBuild build, BuildListener listener) throws IOException, InterruptedException {
                return true;
            }
        };
    }

    public BuildWrapper.Environment setUp(Build build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        return this.setUp(build, launcher, listener);
    }

    public String getIncludes() {
        return this.includes;
    }

    public String getExcludes() {
        return this.excludes;
    }

    public boolean isIncludeAntExcludes() {
        return this.includeAntExcludes;
    }

    public boolean isFlatten() {
        return this.flatten;
    }

    public boolean isHudsonHomeRelative() {
        return this.hudsonHomeRelative;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends BuildWrapperDescriptor {
        public DescriptorImpl() {
            super(CopyToSlaveBuildWrapper.class);
        }

        public static FormValidation checkFile(AbstractProject project, String value, boolean hudsonHomeRelative) throws IOException {
            FilePath rootFilePathOnMaster = !hudsonHomeRelative ? CopyToSlaveUtils.getProjectWorkspaceOnMaster(project, null) : Hudson.getInstance().getRootPath();
            return FilePath.validateFileMask((FilePath)rootFilePathOnMaster, (String)value);
        }

        public FormValidation doCheckIncludes(@AncestorInPath AbstractProject project, @QueryParameter String value, @QueryParameter boolean hudsonHomeRelative) throws IOException {
            return DescriptorImpl.checkFile(project, value, hudsonHomeRelative);
        }

        public FormValidation doCheckExcludes(@AncestorInPath AbstractProject project, @QueryParameter String value, @QueryParameter boolean hudsonHomeRelative) throws IOException {
            return DescriptorImpl.checkFile(project, value, hudsonHomeRelative);
        }

        public String getDisplayName() {
            return new Localizable(ResourceBundleHolder.get(CopyToSlaveBuildWrapper.class), "DisplayName", new Object[0]).toString();
        }

        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }
    }
}

