/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.hudson.plugins.copytoslave;

import hudson.Util;
import hudson.util.DirScanner;
import hudson.util.FileVisitor;
import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;

public class MyGlobDirScanner
extends DirScanner {
    private final String includes;
    private final String excludes;
    private final boolean includeAntExcludes;

    MyGlobDirScanner(String includes, String excludes, boolean includeAntExcludes) {
        this.includes = includes;
        this.excludes = excludes;
        this.includeAntExcludes = includeAntExcludes;
    }

    public void scan(File dir, FileVisitor visitor) throws IOException {
        if (Util.fixEmpty((String)this.includes) == null && this.excludes == null) {
            new DirScanner.Full().scan(dir, visitor);
            return;
        }
        FileSet fs = Util.createFileSet((File)dir, (String)this.includes, (String)this.excludes);
        if (this.includeAntExcludes) {
            fs.setDefaultexcludes(false);
        }
        if (dir.exists()) {
            DirectoryScanner ds = fs.getDirectoryScanner(new Project());
            for (String f : ds.getIncludedFiles()) {
                File file = new File(dir, f);
                visitor.visit(file, f);
            }
        }
    }
}

