/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.hudson.plugins.copytoslave;

import com.michelin.cio.hudson.plugins.copytoslave.CopyToSlaveBuildWrapper;
import com.michelin.cio.hudson.plugins.copytoslave.CopyToSlaveUtils;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Hudson;
import hudson.slaves.SlaveComputer;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.logging.Logger;
import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class CopyToMasterNotifier
extends Notifier {
    private final String includes;
    private final String excludes;
    private static final Logger LOGGER = Logger.getLogger(CopyToMasterNotifier.class.getName());

    @DataBoundConstructor
    public CopyToMasterNotifier(String includes, String excludes) {
        this.includes = includes;
        this.excludes = excludes;
    }

    public boolean needsToRunAfterFinalized() {
        return true;
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        if (Computer.currentComputer() instanceof SlaveComputer) {
            FilePath projectWorkspaceOnMaster = CopyToSlaveUtils.getProjectWorkspaceOnMaster(build);
            FilePath projectWorkspaceOnSlave = build.getProject().getWorkspace();
            LOGGER.finest("Copying '" + this.getIncludes() + "', excluding '" + this.getExcludes() + "' from " + projectWorkspaceOnSlave.toURI() + "' on " + Computer.currentComputer().getNode() + "to '" + projectWorkspaceOnMaster.toURI() + " on the master.");
            projectWorkspaceOnSlave.copyRecursiveTo(this.getIncludes(), this.getExcludes(), projectWorkspaceOnMaster);
        } else if (Computer.currentComputer() instanceof Hudson.MasterComputer) {
            LOGGER.finest("The build is taking place on the master node, no copy back to the master will take place.");
        }
        return true;
    }

    public String getIncludes() {
        return this.includes;
    }

    public String getExcludes() {
        return this.excludes;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public DescriptorImpl() {
            super(CopyToMasterNotifier.class);
        }

        public String getDisplayName() {
            return new Localizable(ResourceBundleHolder.get(CopyToMasterNotifier.class), "DisplayName", new Object[0]).toString();
        }

        public boolean isApplicable(Class<? extends AbstractProject> item) {
            return true;
        }

        public FormValidation doCheckIncludes(@AncestorInPath AbstractProject project, @QueryParameter String value) throws IOException {
            return CopyToSlaveBuildWrapper.DescriptorImpl.checkFile(project, value);
        }

        public FormValidation doCheckExcludes(@AncestorInPath AbstractProject project, @QueryParameter String value) throws IOException {
            return CopyToSlaveBuildWrapper.DescriptorImpl.checkFile(project, value);
        }
    }
}

