/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.hudson.plugins.copytoslave;

import com.michelin.cio.hudson.plugins.copytoslave.CopyToSlaveUtils;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Build;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Hudson;
import hudson.slaves.SlaveComputer;
import hudson.tasks.BuildWrapper;
import hudson.tasks.BuildWrapperDescriptor;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.logging.Logger;
import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class CopyToSlaveBuildWrapper
extends BuildWrapper {
    private final String includes;
    private final String excludes;
    private static final Logger LOGGER = Logger.getLogger(CopyToSlaveBuildWrapper.class.getName());

    @DataBoundConstructor
    public CopyToSlaveBuildWrapper(String includes, String excludes) {
        this.includes = includes;
        this.excludes = excludes;
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        if (Computer.currentComputer() instanceof SlaveComputer) {
            FilePath projectWorkspaceOnMaster = CopyToSlaveUtils.getProjectWorkspaceOnMaster(build);
            FilePath projectWorkspaceOnSlave = build.getProject().getWorkspace();
            LOGGER.finest("Copying '" + this.getIncludes() + "', excluding '" + this.getExcludes() + "' from " + projectWorkspaceOnMaster.toURI() + " on the master " + "to '" + projectWorkspaceOnSlave.toURI() + "' on " + Computer.currentComputer().getNode() + '.');
            projectWorkspaceOnMaster.copyRecursiveTo(this.getIncludes(), this.getExcludes(), projectWorkspaceOnSlave);
        } else if (Computer.currentComputer() instanceof Hudson.MasterComputer) {
            LOGGER.finest("The build is taking place on the master node, no copy to a slave node will take place.");
        }
        return new BuildWrapper.Environment(){

            public boolean tearDown(AbstractBuild build, BuildListener listener) throws IOException, InterruptedException {
                return true;
            }
        };
    }

    public BuildWrapper.Environment setUp(Build build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        return this.setUp(build, launcher, listener);
    }

    public String getIncludes() {
        return this.includes;
    }

    public String getExcludes() {
        return this.excludes;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DescriptorImpl
    extends BuildWrapperDescriptor {
        public DescriptorImpl() {
            super(CopyToSlaveBuildWrapper.class);
        }

        public static FormValidation checkFile(AbstractProject project, String value) throws IOException {
            FilePath projectWorkspaceOnMaster = CopyToSlaveUtils.getProjectWorkspaceOnMaster(project);
            return FilePath.validateFileMask((FilePath)projectWorkspaceOnMaster, (String)value);
        }

        public FormValidation doCheckIncludes(@AncestorInPath AbstractProject project, @QueryParameter String value) throws IOException {
            return DescriptorImpl.checkFile(project, value);
        }

        public FormValidation doCheckExcludes(@AncestorInPath AbstractProject project, @QueryParameter String value) throws IOException {
            return DescriptorImpl.checkFile(project, value);
        }

        public String getDisplayName() {
            return new Localizable(ResourceBundleHolder.get(CopyToSlaveBuildWrapper.class), "DisplayName", new Object[0]).toString();
        }

        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }
    }
}

