/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.copyarchiver;

import com.thalesgroup.hudson.plugins.copyarchiver.ArchivedJobEntry;
import com.thalesgroup.hudson.plugins.copyarchiver.FilePathArchiver;
import hudson.AbortException;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.maven.AbstractMavenProject;
import hudson.maven.MavenBuild;
import hudson.maven.MavenModule;
import hudson.maven.MavenModuleSetBuild;
import hudson.model.AbstractProject;
import hudson.model.Build;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Project;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.Publisher;
import hudson.util.FormFieldValidator;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyArchiver
extends Publisher
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final CopyArchiverDescriptor DESCRIPTOR = new CopyArchiverDescriptor();
    private String sharedDirectoryPath;
    private boolean useTimestamp;
    private String datePattern;
    private boolean flatten;
    private final List<ArchivedJobEntry> archivedJobList = new ArrayList<ArchivedJobEntry>();

    public String getSharedDirectoryPath() {
        return this.sharedDirectoryPath;
    }

    public void setSharedDirectoryPath(String sharedDirectoryPath) {
        this.sharedDirectoryPath = sharedDirectoryPath;
    }

    public boolean getUseTimestamp() {
        return this.useTimestamp;
    }

    public boolean getFlatten() {
        return this.flatten;
    }

    public void setFlatten(boolean flatten) {
        this.flatten = flatten;
    }

    public void setUseTimestamp(boolean useTimestamp) {
        this.useTimestamp = useTimestamp;
    }

    public Descriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    public List<ArchivedJobEntry> getArchivedJobList() {
        return this.archivedJobList;
    }

    public String getDatePattern() {
        return this.datePattern;
    }

    public void setDatePattern(String datePattern) {
        this.datePattern = datePattern;
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = CopyArchiver.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public boolean perform(Build<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        block8: {
            try {
                Project project = (Project)build.getProject();
                if (!build.getResult().equals(Result.UNSTABLE) && !build.getResult().equals(Result.SUCCESS)) break block8;
                listener.getLogger().println("Starting copy archived artifacts in the shared directory.");
                File destDir = null;
                HashMap<String, String> vars = new HashMap<String, String>();
                vars.putAll(build.getEnvironment((TaskListener)listener).descendingMap());
                if (this.useTimestamp) {
                    if (this.datePattern == null || this.datePattern.trim().isEmpty()) {
                        build.setResult(Result.FAILURE);
                        throw new AbortException("The option 'Change the date format' is activated. You must provide a new date pattern.");
                    }
                    SimpleDateFormat sdf = new SimpleDateFormat(this.datePattern);
                    String newBuildIdStr = sdf.format(build.getTimestamp().getTime());
                    vars.put("BUILD_ID", newBuildIdStr);
                }
                String sharedDirectoryPathParsed = Util.replaceMacro((String)this.sharedDirectoryPath, vars);
                sharedDirectoryPathParsed = Util.replaceMacro((String)sharedDirectoryPathParsed, (Map)build.getBuildVariables());
                destDir = new File(sharedDirectoryPathParsed);
                listener.getLogger().println("Copying archived artifacts in the shared directory '" + destDir + "'.");
                CopyArchiver.deleteDir(destDir);
                destDir.mkdirs();
                FilePath destDirFilePath = new FilePath(destDir);
                FilePath lastSuccessfulDirFilePath = null;
                FilePathArchiver lastSuccessfulDirFilePathArchiver = null;
                int numCopied = 0;
                for (ArchivedJobEntry archivedJobEntry : this.archivedJobList) {
                    AbstractProject curProj = Project.findNearest((String)archivedJobEntry.jobName);
                    Run run = curProj.getLastSuccessfulBuild();
                    if (run == null) continue;
                    if (project.getName().equals(archivedJobEntry.jobName)) {
                        lastSuccessfulDirFilePath = project.getModuleRoot();
                        lastSuccessfulDirFilePathArchiver = new FilePathArchiver(lastSuccessfulDirFilePath);
                        numCopied += lastSuccessfulDirFilePathArchiver.copyRecursiveTo(this.flatten, archivedJobEntry.pattern, archivedJobEntry.excludes, destDirFilePath);
                        continue;
                    }
                    if (curProj instanceof AbstractMavenProject) {
                        MavenModuleSetBuild vMavenModuleSetBuild = (MavenModuleSetBuild)run;
                        Map moduleBuildsMap = vMavenModuleSetBuild.getModuleBuilds();
                        for (MavenModule mm : moduleBuildsMap.keySet()) {
                            File lastSuccessfulDir = ((MavenBuild)mm.getLastSuccessfulBuild()).getArtifactsDir();
                            lastSuccessfulDirFilePath = new FilePath(lastSuccessfulDir);
                            lastSuccessfulDirFilePathArchiver = new FilePathArchiver(lastSuccessfulDirFilePath);
                            numCopied += lastSuccessfulDirFilePathArchiver.copyRecursiveTo(this.flatten, archivedJobEntry.pattern, archivedJobEntry.excludes, destDirFilePath);
                        }
                        continue;
                    }
                    File lastSuccessfulDir = run.getArtifactsDir();
                    lastSuccessfulDirFilePath = new FilePath(lastSuccessfulDir);
                    lastSuccessfulDirFilePathArchiver = new FilePathArchiver(lastSuccessfulDirFilePath);
                    numCopied += lastSuccessfulDirFilePathArchiver.copyRecursiveTo(this.flatten, archivedJobEntry.pattern, archivedJobEntry.excludes, destDirFilePath);
                }
                listener.getLogger().println("'" + numCopied + "' artifacts have been copied.");
                listener.getLogger().println("Stop copying archived artifacts in the shared directory.");
            }
            catch (Exception e) {
                e.printStackTrace(listener.fatalError("error"));
                build.setResult(Result.FAILURE);
                return true;
            }
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class CopyArchiverDescriptor
    extends Descriptor<Publisher> {
        private List<AbstractProject> jobs;

        public CopyArchiverDescriptor() {
            super(CopyArchiver.class);
        }

        public String getDisplayName() {
            return "Aggregate the archived artifacts";
        }

        public Publisher newInstance(StaplerRequest req) throws Descriptor.FormException {
            CopyArchiver pub = new CopyArchiver();
            req.bindParameters((Object)pub, "copyarchiver.");
            pub.getArchivedJobList().addAll(req.bindParametersToList(ArchivedJobEntry.class, "copyarchiver.entry."));
            return pub;
        }

        public String getHelpFile() {
            return "/plugin/copyarchiver/help.html";
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public List<AbstractProject> getJobs() {
            return Hudson.getInstance().getItems(AbstractProject.class);
        }

        public void doDateTimePatternCheck(final StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            new FormFieldValidator(req, rsp, true){

                public void check() throws IOException, ServletException {
                    String pattern = req.getParameter("value");
                    if (pattern == null || pattern.trim().length() == 0) {
                        this.error("You must provide a pattern value");
                    }
                    try {
                        new SimpleDateFormat(pattern);
                    }
                    catch (NullPointerException npe) {
                        this.error("Invalid input: " + npe.getMessage());
                        return;
                    }
                    catch (IllegalArgumentException iae) {
                        this.error("Invalid input: " + iae.getMessage());
                        return;
                    }
                }
            }.process();
        }
    }
}

