/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.copyarchiver;

import hudson.FilePath;
import hudson.Util;
import hudson.remoting.VirtualChannel;
import hudson.util.IOException2;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Copy;

public class FilePathArchiver
implements Serializable {
    FilePath filePath;

    public FilePathArchiver(FilePath filePath) {
        this.filePath = filePath;
    }

    public int copyRecursiveTo(final boolean flatten, final String fileMask, final String excludes, final FilePath target) throws IOException, InterruptedException {
        if (this.filePath.getChannel() == target.getChannel()) {
            return (Integer)this.filePath.act((FilePath.FileCallable)new FilePath.FileCallable<Integer>(){

                public Integer invoke(File base, VirtualChannel channel) throws IOException {
                    if (!base.exists()) {
                        return 0;
                    }
                    assert (target.getChannel() == null);
                    try {
                        class CopyImpl
                        extends Copy {
                            private int copySize;

                            public CopyImpl() {
                                this.setProject(new Project());
                            }

                            protected void doFileOperations() {
                                this.copySize = this.fileCopyMap.size();
                                super.doFileOperations();
                            }

                            public int getNumCopied() {
                                return this.copySize;
                            }
                        }
                        CopyImpl copyTask = new CopyImpl();
                        copyTask.setTodir(new File(target.getRemote()));
                        copyTask.addFileset(Util.createFileSet((File)base, (String)fileMask, (String)excludes));
                        copyTask.setIncludeEmptyDirs(false);
                        copyTask.setFlatten(flatten);
                        copyTask.execute();
                        return copyTask.getNumCopied();
                    }
                    catch (BuildException e) {
                        throw new IOException2("Failed to copy " + base + "/" + fileMask + " to " + target, (Throwable)e);
                    }
                }
            });
        }
        return this.filePath.copyRecursiveTo(fileMask, excludes, target);
    }
}

