/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.copyarchiver;

import com.thalesgroup.hudson.plugins.copyarchiver.ArchivedJobEntry;
import com.thalesgroup.hudson.plugins.copyarchiver.CopyArchiver;
import com.thalesgroup.hudson.plugins.copyarchiver.FilePathArchiver;
import hudson.AbortException;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.maven.AbstractMavenProject;
import hudson.maven.MavenBuild;
import hudson.maven.MavenModule;
import hudson.maven.MavenModuleSetBuild;
import hudson.model.AbstractProject;
import hudson.model.Build;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Project;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.Publisher;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class CopyArchiver
extends Publisher
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final CopyArchiverDescriptor DESCRIPTOR = new CopyArchiverDescriptor();
    private String sharedDirectoryPath;
    private boolean useTimestamp;
    private String datePattern;
    private boolean flatten;
    private final List<ArchivedJobEntry> archivedJobList = new ArrayList();

    public String getSharedDirectoryPath() {
        return this.sharedDirectoryPath;
    }

    public void setSharedDirectoryPath(String sharedDirectoryPath) {
        this.sharedDirectoryPath = sharedDirectoryPath;
    }

    public boolean getUseTimestamp() {
        return this.useTimestamp;
    }

    public boolean getFlatten() {
        return this.flatten;
    }

    public void setFlatten(boolean flatten) {
        this.flatten = flatten;
    }

    public void setUseTimestamp(boolean useTimestamp) {
        this.useTimestamp = useTimestamp;
    }

    public Descriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    public List<ArchivedJobEntry> getArchivedJobList() {
        return this.archivedJobList;
    }

    public String getDatePattern() {
        return this.datePattern;
    }

    public void setDatePattern(String datePattern) {
        this.datePattern = datePattern;
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = CopyArchiver.deleteDir((File)new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    private String filterField(Build<?, ?> build, BuildListener listener, String fieldText) throws InterruptedException, IOException {
        String str = null;
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.putAll(build.getEnvironment((TaskListener)listener).descendingMap());
        if (this.useTimestamp && this.datePattern != null) {
            SimpleDateFormat sdf = new SimpleDateFormat(this.datePattern);
            String newBuildIdStr = sdf.format(build.getTimestamp().getTime());
            vars.put("BUILD_ID", newBuildIdStr);
        }
        str = Util.replaceMacro((String)fieldText, vars);
        str = Util.replaceMacro((String)str, (Map)build.getBuildVariables());
        return str;
    }

    public boolean perform(Build<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        block7: {
            try {
                Project project = (Project)build.getProject();
                if (!build.getResult().equals(Result.UNSTABLE) && !build.getResult().equals(Result.SUCCESS)) break block7;
                listener.getLogger().println("Starting copy archived artifacts in the shared directory.");
                File destDir = null;
                HashMap vars = new HashMap();
                vars.putAll(build.getEnvironment((TaskListener)listener).descendingMap());
                if (this.useTimestamp && (this.datePattern == null || this.datePattern.trim().isEmpty())) {
                    build.setResult(Result.FAILURE);
                    throw new AbortException("The option 'Change the date format' is activated. You must provide a new date pattern.");
                }
                String sharedDirectoryPathParsed = this.filterField(build, listener, this.sharedDirectoryPath);
                destDir = new File(sharedDirectoryPathParsed);
                listener.getLogger().println("Copying archived artifacts in the shared directory '" + destDir + "'.");
                CopyArchiver.deleteDir((File)destDir);
                destDir.mkdirs();
                FilePath destDirFilePath = new FilePath(destDir);
                FilePath lastSuccessfulDirFilePath = null;
                FilePathArchiver lastSuccessfulDirFilePathArchiver = null;
                int numCopied = 0;
                for (ArchivedJobEntry archivedJobEntry : this.archivedJobList) {
                    AbstractProject curProj = Project.findNearest((String)archivedJobEntry.jobName);
                    Run run = curProj.getLastSuccessfulBuild();
                    if (run == null) continue;
                    if (project.getName().equals(archivedJobEntry.jobName)) {
                        lastSuccessfulDirFilePath = project.getWorkspace();
                        lastSuccessfulDirFilePathArchiver = new FilePathArchiver(lastSuccessfulDirFilePath);
                        numCopied += lastSuccessfulDirFilePathArchiver.copyRecursiveTo(this.flatten, this.filterField(build, listener, archivedJobEntry.pattern), this.filterField(build, listener, archivedJobEntry.excludes), destDirFilePath);
                        continue;
                    }
                    if (curProj instanceof AbstractMavenProject) {
                        MavenModuleSetBuild vMavenModuleSetBuild = (MavenModuleSetBuild)run;
                        Map moduleBuildsMap = vMavenModuleSetBuild.getModuleBuilds();
                        for (MavenModule mm : moduleBuildsMap.keySet()) {
                            File lastSuccessfulDir = ((MavenBuild)mm.getLastSuccessfulBuild()).getArtifactsDir();
                            lastSuccessfulDirFilePath = new FilePath(lastSuccessfulDir);
                            lastSuccessfulDirFilePathArchiver = new FilePathArchiver(lastSuccessfulDirFilePath);
                            numCopied += lastSuccessfulDirFilePathArchiver.copyRecursiveTo(this.flatten, this.filterField(build, listener, archivedJobEntry.pattern), this.filterField(build, listener, archivedJobEntry.excludes), destDirFilePath);
                        }
                        continue;
                    }
                    File lastSuccessfulDir = run.getArtifactsDir();
                    lastSuccessfulDirFilePath = new FilePath(lastSuccessfulDir);
                    lastSuccessfulDirFilePathArchiver = new FilePathArchiver(lastSuccessfulDirFilePath);
                    numCopied += lastSuccessfulDirFilePathArchiver.copyRecursiveTo(this.flatten, this.filterField(build, listener, archivedJobEntry.pattern), this.filterField(build, listener, archivedJobEntry.excludes), destDirFilePath);
                }
                listener.getLogger().println("'" + numCopied + "' artifacts have been copied.");
                listener.getLogger().println("Stop copying archived artifacts in the shared directory.");
            }
            catch (Exception e) {
                e.printStackTrace(listener.fatalError("error"));
                build.setResult(Result.FAILURE);
                return true;
            }
        }
        return true;
    }
}

