/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.copyarchiver;

import com.thalesgroup.hudson.plugins.copyarchiver.ArchivedJobEntry;
import com.thalesgroup.hudson.plugins.copyarchiver.FilePathArchiver;
import com.thalesgroup.hudson.plugins.copyarchiver.util.CopyArchiverLogger;
import hudson.AbortException;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Hudson;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyArchiverPublisher
extends Publisher
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String sharedDirectoryPath;
    private boolean useTimestamp;
    private String datePattern;
    private boolean flatten;
    private boolean deleteShared;
    private List<ArchivedJobEntry> archivedJobList = new ArrayList();

    public String getSharedDirectoryPath() {
        return this.sharedDirectoryPath;
    }

    public void setSharedDirectoryPath(String sharedDirectoryPath) {
        this.sharedDirectoryPath = sharedDirectoryPath;
    }

    public boolean getUseTimestamp() {
        return this.useTimestamp;
    }

    public boolean getFlatten() {
        return this.flatten;
    }

    public void setFlatten(boolean flatten) {
        this.flatten = flatten;
    }

    public void setUseTimestamp(boolean useTimestamp) {
        this.useTimestamp = useTimestamp;
    }

    public List<ArchivedJobEntry> getArchivedJobList() {
        return this.archivedJobList;
    }

    public void setArchivedJobList(List<ArchivedJobEntry> archivedJobList) {
        this.archivedJobList = archivedJobList;
    }

    public String getDatePattern() {
        return this.datePattern;
    }

    public void setDatePattern(String datePattern) {
        this.datePattern = datePattern;
    }

    public boolean getDeleteShared() {
        return this.deleteShared;
    }

    public void setDeleteShared(boolean deleteShared) {
        this.deleteShared = deleteShared;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        if (build.getResult().equals(Result.UNSTABLE) || build.getResult().equals(Result.SUCCESS)) {
            AbstractProject project = build.getProject();
            String projectName = project.getName();
            Boolean result = false;
            try {
                if (this.useTimestamp && (this.datePattern == null || this.datePattern.trim().length() == 0)) {
                    build.setResult(Result.FAILURE);
                    throw new AbortException("The option 'Change the date format' is activated. You must provide a new date pattern.");
                }
                FilePath destDirFilePath = new FilePath(build.getWorkspace().getChannel(), this.filterField(build, listener, this.sharedDirectoryPath));
                result = (Boolean)build.getWorkspace().act((FilePath.FileCallable)new /* Unavailable Anonymous Inner Class!! */);
                if (!result.booleanValue()) {
                    CopyArchiverLogger.log((BuildListener)listener, (String)"An error has been occured during the copyarchiver process.");
                    build.setResult(Result.FAILURE);
                    return false;
                }
                File lastSuccessfulDir = null;
                FilePathArchiver lastSuccessfulDirFilePathArchiver = null;
                int numCopied = 0;
                for (ArchivedJobEntry archivedJobEntry : this.archivedJobList) {
                    CopyArchiverLogger.log((BuildListener)listener, (String)("Hudson full name" + Hudson.getInstance()));
                    AbstractProject curProj = (AbstractProject)Hudson.getInstance().getItem(archivedJobEntry.jobName);
                    Run run = curProj.getLastSuccessfulBuild();
                    if (run != null) {
                        if (projectName.equals(archivedJobEntry.jobName)) {
                            lastSuccessfulDirFilePathArchiver = new FilePathArchiver(build.getModuleRoot());
                        } else {
                            lastSuccessfulDir = run.getArtifactsDir();
                            lastSuccessfulDirFilePathArchiver = new FilePathArchiver(new FilePath(lastSuccessfulDir));
                        }
                    } else {
                        lastSuccessfulDirFilePathArchiver = new FilePathArchiver(build.getModuleRoot());
                    }
                    numCopied += lastSuccessfulDirFilePathArchiver.copyRecursiveTo(this.flatten, this.filterField(build, listener, archivedJobEntry.pattern), this.filterField(build, listener, archivedJobEntry.excludes), destDirFilePath);
                }
                CopyArchiverLogger.log((BuildListener)listener, (String)("'" + numCopied + "' artifacts have been copied."));
                CopyArchiverLogger.log((BuildListener)listener, (String)"Stop copying archived artifacts in the shared directory.");
                return true;
            }
            catch (Exception e) {
                CopyArchiverLogger.log((BuildListener)listener, (String)("Error on copyarchiver analysis: " + e));
                build.setResult(Result.FAILURE);
                return false;
            }
        }
        return true;
    }

    private String filterField(AbstractBuild<?, ?> build, BuildListener listener, String fieldText) throws InterruptedException, IOException {
        String str = null;
        HashMap vars = new HashMap();
        Set set = build.getEnvironment((TaskListener)listener).entrySet();
        for (Map.Entry entry : set) {
            vars.put(entry.getKey(), entry.getValue());
        }
        if (this.useTimestamp && this.datePattern != null) {
            SimpleDateFormat sdf = new SimpleDateFormat(this.datePattern);
            String newBuildIdStr = sdf.format(build.getTimestamp().getTime());
            vars.put("BUILD_ID", newBuildIdStr);
        }
        str = Util.replaceMacro((String)fieldText, vars);
        str = Util.replaceMacro((String)str, (Map)build.getBuildVariables());
        return str;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    static /* synthetic */ boolean access$000(CopyArchiverPublisher x0) {
        return x0.deleteShared;
    }
}

