/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.copyarchiver;

import com.thalesgroup.hudson.plugins.copyarchiver.ArchivedJobEntry;
import com.thalesgroup.hudson.plugins.copyarchiver.FilePathArchiver;
import com.thalesgroup.hudson.plugins.copyarchiver.util.CopyArchiverLogger;
import hudson.AbortException;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.util.FormFieldValidator;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyArchiverPublisher
extends Publisher
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String sharedDirectoryPath;
    private boolean useTimestamp;
    private String datePattern;
    private boolean flatten;
    private boolean deleteShared;
    private List<ArchivedJobEntry> archivedJobList = new ArrayList<ArchivedJobEntry>();

    public String getSharedDirectoryPath() {
        return this.sharedDirectoryPath;
    }

    public void setSharedDirectoryPath(String sharedDirectoryPath) {
        this.sharedDirectoryPath = sharedDirectoryPath;
    }

    public boolean getUseTimestamp() {
        return this.useTimestamp;
    }

    public boolean getFlatten() {
        return this.flatten;
    }

    public void setFlatten(boolean flatten) {
        this.flatten = flatten;
    }

    public void setUseTimestamp(boolean useTimestamp) {
        this.useTimestamp = useTimestamp;
    }

    public List<ArchivedJobEntry> getArchivedJobList() {
        return this.archivedJobList;
    }

    public void setArchivedJobList(List<ArchivedJobEntry> archivedJobList) {
        this.archivedJobList = archivedJobList;
    }

    public String getDatePattern() {
        return this.datePattern;
    }

    public void setDatePattern(String datePattern) {
        this.datePattern = datePattern;
    }

    public boolean getDeleteShared() {
        return this.deleteShared;
    }

    public void setDeleteShared(boolean deleteShared) {
        this.deleteShared = deleteShared;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, final BuildListener listener) throws InterruptedException, IOException {
        if (build.getResult().equals(Result.UNSTABLE) || build.getResult().equals(Result.SUCCESS)) {
            AbstractProject project = build.getProject();
            String projectName = project.getName();
            Boolean result = false;
            try {
                if (this.useTimestamp && (this.datePattern == null || this.datePattern.trim().length() == 0)) {
                    build.setResult(Result.FAILURE);
                    throw new AbortException("The option 'Change the date format' is activated. You must provide a new date pattern.");
                }
                final FilePath destDirFilePath = new FilePath(build.getWorkspace().getChannel(), this.filterField(build, listener, this.sharedDirectoryPath));
                result = (Boolean)build.getWorkspace().act((FilePath.FileCallable)new FilePath.FileCallable<Boolean>(){

                    public Boolean invoke(File f, VirtualChannel channel) throws IOException {
                        try {
                            CopyArchiverLogger.log(listener, "Copying archived artifacts in the shared directory '" + destDirFilePath + "'.");
                            if (!destDirFilePath.isDirectory()) {
                                destDirFilePath.mkdirs();
                            }
                            if (CopyArchiverPublisher.this.deleteShared) {
                                destDirFilePath.deleteRecursive();
                            }
                            return true;
                        }
                        catch (InterruptedException ie) {
                            return false;
                        }
                    }
                });
                if (!result.booleanValue()) {
                    CopyArchiverLogger.log(listener, "An error has been occured during the copyarchiver process.");
                    build.setResult(Result.FAILURE);
                    return false;
                }
                File lastSuccessfulDir = null;
                FilePathArchiver lastSuccessfulDirFilePathArchiver = null;
                int numCopied = 0;
                for (ArchivedJobEntry archivedJobEntry : this.archivedJobList) {
                    CopyArchiverLogger.log(listener, "Hudson full name" + Hudson.getInstance());
                    AbstractProject curProj = (AbstractProject)Hudson.getInstance().getItem(archivedJobEntry.jobName);
                    Run run = curProj.getLastSuccessfulBuild();
                    if (run != null) {
                        if (projectName.equals(archivedJobEntry.jobName)) {
                            lastSuccessfulDirFilePathArchiver = new FilePathArchiver(build.getModuleRoot());
                        } else {
                            lastSuccessfulDir = run.getArtifactsDir();
                            lastSuccessfulDirFilePathArchiver = new FilePathArchiver(new FilePath(lastSuccessfulDir));
                        }
                    } else {
                        lastSuccessfulDirFilePathArchiver = new FilePathArchiver(build.getModuleRoot());
                    }
                    numCopied += lastSuccessfulDirFilePathArchiver.copyRecursiveTo(this.flatten, this.filterField(build, listener, archivedJobEntry.pattern), this.filterField(build, listener, archivedJobEntry.excludes), destDirFilePath);
                }
                CopyArchiverLogger.log(listener, "'" + numCopied + "' artifacts have been copied.");
                CopyArchiverLogger.log(listener, "Stop copying archived artifacts in the shared directory.");
                return true;
            }
            catch (Exception e) {
                CopyArchiverLogger.log(listener, "Error on copyarchiver analysis: " + e);
                build.setResult(Result.FAILURE);
                return false;
            }
        }
        return true;
    }

    private String filterField(AbstractBuild<?, ?> build, BuildListener listener, String fieldText) throws InterruptedException, IOException {
        String str = null;
        HashMap vars = new HashMap();
        Set set = build.getEnvironment((TaskListener)listener).entrySet();
        for (Map.Entry entry : set) {
            vars.put(entry.getKey(), entry.getValue());
        }
        if (this.useTimestamp && this.datePattern != null) {
            SimpleDateFormat sdf = new SimpleDateFormat(this.datePattern);
            String newBuildIdStr = sdf.format(build.getTimestamp().getTime());
            vars.put("BUILD_ID", newBuildIdStr);
        }
        str = Util.replaceMacro((String)fieldText, vars);
        str = Util.replaceMacro((String)str, (Map)build.getBuildVariables());
        return str;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class CopyArchiverDescriptor
    extends BuildStepDescriptor<Publisher> {
        private List<AbstractProject> jobs;

        public CopyArchiverDescriptor() {
            super(CopyArchiverPublisher.class);
            this.load();
        }

        public String getDisplayName() {
            return "Aggregate the archived artifacts";
        }

        public Publisher newInstance(StaplerRequest req) throws Descriptor.FormException {
            CopyArchiverPublisher pub = new CopyArchiverPublisher();
            req.bindParameters((Object)pub, "copyarchiver.");
            pub.getArchivedJobList().addAll(req.bindParametersToList(ArchivedJobEntry.class, "copyarchiver.entry."));
            return pub;
        }

        public String getHelpFile() {
            return "/plugin/copyarchiver/help.html";
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public List<AbstractProject> getJobs() {
            return Hudson.getInstance().getItems(AbstractProject.class);
        }

        public void doDateTimePatternCheck(final StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            new FormFieldValidator(req, rsp, true){

                public void check() throws IOException, ServletException {
                    String pattern = req.getParameter("value");
                    if (pattern == null || pattern.trim().length() == 0) {
                        this.error("You must provide a pattern value");
                    }
                    try {
                        new SimpleDateFormat(pattern);
                    }
                    catch (NullPointerException npe) {
                        this.error("Invalid input: " + npe.getMessage());
                        return;
                    }
                    catch (IllegalArgumentException iae) {
                        this.error("Invalid input: " + iae.getMessage());
                        return;
                    }
                }
            }.process();
        }
    }
}

