/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.copyarchiver;

import com.thalesgroup.hudson.plugins.copyarchiver.ArchivedJobEntry;
import com.thalesgroup.hudson.plugins.copyarchiver.FilePathArchiver;
import com.thalesgroup.hudson.plugins.copyarchiver.Messages;
import com.thalesgroup.hudson.plugins.copyarchiver.util.CopyArchiverLogger;
import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixConfiguration;
import hudson.matrix.MatrixProject;
import hudson.matrix.MatrixRun;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyArchiverPublisher
extends Notifier
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String sharedDirectoryPath;
    private transient boolean useTimestamp;
    private transient String datePattern;
    private boolean flatten;
    private boolean deleteShared;
    private transient boolean usePreviousVersion043WithTimestamp;
    private List<ArchivedJobEntry> archivedJobList = new ArrayList<ArchivedJobEntry>();

    public CopyArchiverPublisher() {
    }

    @DataBoundConstructor
    public CopyArchiverPublisher(String sharedDirectoryPath, String datePattern, boolean flatten, boolean deleteShared, List<ArchivedJobEntry> archivedJobList) {
        this.sharedDirectoryPath = sharedDirectoryPath;
        this.datePattern = datePattern;
        this.flatten = flatten;
        this.deleteShared = deleteShared;
        this.archivedJobList = archivedJobList;
    }

    public String getSharedDirectoryPath() {
        return this.sharedDirectoryPath;
    }

    public boolean isUsePreviousVersion043WithTimestamp() {
        return this.usePreviousVersion043WithTimestamp;
    }

    public void setSharedDirectoryPath(String sharedDirectoryPath) {
        this.sharedDirectoryPath = sharedDirectoryPath;
    }

    public boolean getUseTimestamp() {
        return this.useTimestamp;
    }

    public boolean getFlatten() {
        return this.flatten;
    }

    public void setFlatten(boolean flatten) {
        this.flatten = flatten;
    }

    public void setUseTimestamp(boolean useTimestamp) {
        this.useTimestamp = useTimestamp;
    }

    public List<ArchivedJobEntry> getArchivedJobList() {
        return this.archivedJobList;
    }

    public void setArchivedJobList(List<ArchivedJobEntry> archivedJobList) {
        this.archivedJobList = archivedJobList;
    }

    public String getDatePattern() {
        return this.datePattern;
    }

    public void setDatePattern(String datePattern) {
        this.datePattern = datePattern;
    }

    public boolean getDeleteShared() {
        return this.deleteShared;
    }

    public void setDeleteShared(boolean deleteShared) {
        this.deleteShared = deleteShared;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, final BuildListener listener) throws InterruptedException, IOException {
        if (build.getResult().equals(Result.UNSTABLE) || build.getResult().equals(Result.SUCCESS)) {
            AbstractProject project = build.getProject();
            try {
                if (this.useTimestamp) {
                    CopyArchiverLogger.log(listener, "[WARNING] - You have installed a new version of te copyarchiver Hudson instance");
                    CopyArchiverLogger.log(listener, "[WARNING] - In this new version, the usuage of timestamp has been removed.");
                    CopyArchiverLogger.log(listener, "[WARNING] - You need to use the zentimestamp Hudson plugin.");
                    if (this.datePattern == null || this.datePattern.trim().length() == 0) {
                        build.setResult(Result.FAILURE);
                        throw new AbortException("The option 'Change the date format' is activated. You must provide a new date pattern.");
                    }
                }
                final FilePath destDirFilePath = new FilePath(new File(this.filterField(build, listener, this.sharedDirectoryPath)));
                final boolean isMatrixExcutorProject = MatrixConfiguration.class.isAssignableFrom(project.getClass());
                Boolean result = (Boolean)build.getWorkspace().act((FilePath.FileCallable)new FilePath.FileCallable<Boolean>(){

                    public Boolean invoke(File f, VirtualChannel channel) throws IOException {
                        try {
                            CopyArchiverLogger.log(listener, "Copying archived artifacts in the shared directory '" + destDirFilePath + "'.");
                            if (CopyArchiverPublisher.this.deleteShared) {
                                if (isMatrixExcutorProject) {
                                    CopyArchiverLogger.log(listener, "[WARNING] - The type of the current job is matrix project");
                                    CopyArchiverLogger.log(listener, "[WARNING] - In this special case, the delete operation is not supported.");
                                    CopyArchiverLogger.log(listener, "[WARNING] - Checking 'Delete the shared directory.' option has no effect.");
                                    CopyArchiverLogger.log(listener, "[WARNING] - Uncheck 'Delete the shared directory.' option and manaed the shared directory in an other way.");
                                    return true;
                                }
                                destDirFilePath.deleteRecursive();
                            }
                            if (!destDirFilePath.isDirectory()) {
                                destDirFilePath.mkdirs();
                            }
                            return true;
                        }
                        catch (InterruptedException ie) {
                            return false;
                        }
                    }
                });
                if (!result.booleanValue()) {
                    CopyArchiverLogger.log(listener, "An error has been occured during the copyarchiver process.");
                    build.setResult(Result.FAILURE);
                    return false;
                }
                int numCopied = 0;
                for (ArchivedJobEntry archivedJobEntry : this.archivedJobList) {
                    File lastSuccessfulDir;
                    FilePathArchiver lastSuccessfulDirFilePathArchiver;
                    AbstractProject selectedProject = (AbstractProject)Hudson.getInstance().getItem(archivedJobEntry.getJobName());
                    if (this.isSameProject(project, selectedProject)) {
                        lastSuccessfulDirFilePathArchiver = new FilePathArchiver(build.getWorkspace());
                        numCopied += lastSuccessfulDirFilePathArchiver.copyRecursiveTo(this.flatten, this.filterField(build, listener, archivedJobEntry.getPattern()), this.filterField(build, listener, archivedJobEntry.getExcludes()), destDirFilePath);
                        continue;
                    }
                    if (MatrixProject.class.isAssignableFrom(selectedProject.getClass())) {
                        MatrixProject matrixProject = (MatrixProject)selectedProject;
                        MatrixBuild matrixBuild = (MatrixBuild)matrixProject.getLastSuccessfulBuild();
                        if (matrixBuild == null) {
                            CopyArchiverLogger.log(listener, "The selected project has never built. No copy will be proceded.");
                            return true;
                        }
                        List runs = matrixBuild.getRuns();
                        for (MatrixRun run : runs) {
                            lastSuccessfulDir = run.getArtifactsDir();
                            lastSuccessfulDirFilePathArchiver = new FilePathArchiver(new FilePath(launcher.getChannel(), lastSuccessfulDir.getAbsolutePath()));
                            numCopied += lastSuccessfulDirFilePathArchiver.copyRecursiveTo(this.flatten, this.filterField(build, listener, archivedJobEntry.getPattern()), this.filterField(build, listener, archivedJobEntry.getExcludes()), destDirFilePath);
                        }
                        continue;
                    }
                    Run run = selectedProject.getLastSuccessfulBuild();
                    if (run == null) {
                        CopyArchiverLogger.log(listener, "The selected has never built. No copy will be proceded.");
                        return true;
                    }
                    lastSuccessfulDir = run.getArtifactsDir();
                    lastSuccessfulDirFilePathArchiver = new FilePathArchiver(new FilePath(launcher.getChannel(), lastSuccessfulDir.getAbsolutePath()));
                    numCopied += lastSuccessfulDirFilePathArchiver.copyRecursiveTo(this.flatten, this.filterField(build, listener, archivedJobEntry.getPattern()), this.filterField(build, listener, archivedJobEntry.getExcludes()), destDirFilePath);
                }
                CopyArchiverLogger.log(listener, "'" + numCopied + "' artifacts have been copied.");
                CopyArchiverLogger.log(listener, "Stop copying archived artifacts in the shared directory.");
                return true;
            }
            catch (Exception e) {
                CopyArchiverLogger.log(listener, "Error on copyarchiver analysis: " + e);
                build.setResult(Result.FAILURE);
                return false;
            }
        }
        return true;
    }

    private boolean isSameProject(AbstractProject executorProject, AbstractProject selectedProject) {
        boolean matrixSelected = MatrixProject.class.isAssignableFrom(selectedProject.getClass());
        boolean matrixExecutor = MatrixConfiguration.class.isAssignableFrom(executorProject.getClass());
        if (matrixExecutor && !matrixSelected) {
            return false;
        }
        if (matrixExecutor && matrixSelected) {
            return executorProject.getParent().equals(selectedProject);
        }
        if (!matrixExecutor && matrixSelected) {
            return false;
        }
        return selectedProject.equals(executorProject);
    }

    private String filterField(AbstractBuild<?, ?> build, BuildListener listener, String fieldText) throws InterruptedException, IOException {
        HashMap vars = new HashMap();
        Set set = build.getEnvironment((TaskListener)listener).entrySet();
        for (Map.Entry entry : set) {
            vars.put(entry.getKey(), entry.getValue());
        }
        if (this.usePreviousVersion043WithTimestamp && this.useTimestamp && this.datePattern != null) {
            SimpleDateFormat sdf = new SimpleDateFormat(this.datePattern);
            String newBuildIdStr = sdf.format(build.getTimestamp().getTime());
            vars.put("BUILD_ID", newBuildIdStr);
        }
        String str = Util.replaceMacro((String)fieldText, vars);
        str = Util.replaceMacro((String)str, (Map)build.getBuildVariables());
        return str;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public Object readResolve() {
        if (this.useTimestamp && this.datePattern != null) {
            this.usePreviousVersion043WithTimestamp = true;
        }
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class CopyArchiverDescriptor
    extends BuildStepDescriptor<Publisher> {
        private List<AbstractProject> jobs;

        public CopyArchiverDescriptor() {
            super(CopyArchiverPublisher.class);
            this.load();
        }

        public String getDisplayName() {
            return Messages.copyArchiver_displayName();
        }

        public Publisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            CopyArchiverPublisher pub = new CopyArchiverPublisher();
            req.bindJSON((Object)pub, formData);
            List archivedJobEntries = req.bindParametersToList(ArchivedJobEntry.class, "copyarchiver.entry.");
            pub.getArchivedJobList().addAll(archivedJobEntries);
            return pub;
        }

        public String getHelpFile() {
            return "/plugin/copyarchiver/help.html";
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public List<AbstractProject> getJobs() {
            return Hudson.getInstance().getItems(AbstractProject.class);
        }

        public FormValidation doDateTimePatternCheck(@QueryParameter(value="value") String pattern) {
            if (!Hudson.getInstance().hasPermission(Hudson.ADMINISTER)) {
                return FormValidation.ok();
            }
            if (pattern == null || pattern.trim().length() == 0) {
                return FormValidation.error((String)"You must provide a pattern value");
            }
            try {
                new SimpleDateFormat(pattern);
            }
            catch (NullPointerException npe) {
                return FormValidation.error((String)("Invalid input: " + npe.getMessage()));
            }
            catch (IllegalArgumentException iae) {
                return FormValidation.error((String)("Invalid input: " + iae.getMessage()));
            }
            return FormValidation.ok();
        }
    }
}

