/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.copyarchiver;

import hudson.FilePath;
import hudson.Functions;
import hudson.Util;
import hudson.model.Hudson;
import hudson.remoting.Future;
import hudson.remoting.Pipe;
import hudson.util.IOException2;
import hudson.util.jna.GNUCLibrary;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.io.IOUtils;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarInputStream;
import org.apache.tools.tar.TarOutputStream;

/*
 * Exception performing whole class analysis ignored.
 */
public class FilePathArchiver
implements Serializable {
    FilePath filePath;

    public FilePathArchiver(FilePath filePath) {
        this.filePath = filePath;
    }

    public int copyRecursiveTo(boolean flatten, String fileMask, String excludes, FilePath target) throws IOException, InterruptedException {
        if (this.filePath.getChannel() == target.getChannel()) {
            return (Integer)this.filePath.act((FilePath.FileCallable)new /* Unavailable Anonymous Inner Class!! */);
        }
        Pipe pipe = Pipe.createRemoteToLocal();
        Future future = this.filePath.actAsync((FilePath.FileCallable)new /* Unavailable Anonymous Inner Class!! */);
        try {
            FilePathArchiver.readFromTar((boolean)flatten, (String)(this.filePath.getRemote() + '/' + fileMask), (File)new File(target.getRemote()), (InputStream)FilePath.TarCompression.GZIP.extract(pipe.getIn()));
        }
        catch (IOException e) {
            try {
                future.get(3L, TimeUnit.SECONDS);
                throw e;
            }
            catch (ExecutionException x) {
                throw new IOException2(Functions.printThrowable((Throwable)e), (Throwable)x);
            }
            catch (TimeoutException _) {
                throw e;
            }
        }
        try {
            return (Integer)future.get();
        }
        catch (ExecutionException e) {
            throw new IOException2((Throwable)e);
        }
    }

    private Integer writeToTar(File baseDir, String fileMask, String excludes, OutputStream out) throws IOException {
        String[] files;
        FileSet fs = Util.createFileSet((File)baseDir, (String)fileMask, (String)excludes);
        byte[] buf = new byte[8192];
        TarOutputStream tar = new TarOutputStream((OutputStream)new BufferedOutputStream(out));
        tar.setLongFileMode(2);
        if (baseDir.exists()) {
            DirectoryScanner ds = fs.getDirectoryScanner(new Project());
            files = ds.getIncludedFiles();
        } else {
            files = new String[]{};
        }
        for (String f : files) {
            if (Functions.isWindows()) {
                f = f.replace('\\', '/');
            }
            File file = new File(baseDir, f);
            TarEntry te = new TarEntry(f);
            te.setModTime(file.lastModified());
            if (!file.isDirectory()) {
                te.setSize(file.length());
            }
            tar.putNextEntry(te);
            if (!file.isDirectory()) {
                int len;
                FileInputStream in = new FileInputStream(file);
                while ((len = in.read(buf)) >= 0) {
                    tar.write(buf, 0, len);
                }
                in.close();
            }
            tar.closeEntry();
        }
        tar.close();
        return files.length;
    }

    private static void readFromTar(String name, File baseDir, InputStream in) throws IOException {
        FilePathArchiver.readFromTar((boolean)false, (String)name, (File)baseDir, (InputStream)in);
    }

    private static String getFileNameWithoutLeadingDirectory(String name) {
        String fileName = name.replace('\\', '/');
        if (!fileName.contains("/")) {
            return fileName;
        }
        if (fileName.endsWith("/")) {
            return null;
        }
        return fileName.substring(fileName.lastIndexOf("/") + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readFromTar(boolean isFlatten, String name, File baseDir, InputStream in) throws IOException {
        block17: {
            TarInputStream t = new TarInputStream(in);
            block10: while (true) {
                try {
                    TarEntry te;
                    while ((te = t.getNextEntry()) != null) {
                        File f = new File(baseDir, te.getName());
                        if (te.isDirectory()) {
                            if (isFlatten) continue;
                            f.mkdirs();
                            continue;
                        }
                        if (!isFlatten) {
                            File parent = f.getParentFile();
                            if (parent != null) {
                                parent.mkdirs();
                            }
                        } else {
                            f = new File(baseDir, FilePathArchiver.getFileNameWithoutLeadingDirectory((String)te.getName()));
                        }
                        FileOutputStream fos = new FileOutputStream(f);
                        try {
                            IOUtils.copy((InputStream)t, (OutputStream)fos);
                        }
                        finally {
                            ((OutputStream)fos).close();
                        }
                        f.setLastModified(te.getModTime().getTime());
                        int mode = te.getMode() & 0x1FF;
                        if (mode == 0 || Hudson.isWindows()) continue;
                        try {
                            GNUCLibrary.LIBC.chmod(f.getPath(), mode);
                            continue block10;
                        }
                        catch (NoClassDefFoundError e) {
                        }
                    }
                    break block17;
                }
                catch (IOException e) {
                    throw new IOException2("Failed to extract " + name, (Throwable)e);
                }
            }
            finally {
                t.close();
            }
        }
    }

    static /* synthetic */ Integer access$000(FilePathArchiver x0, File x1, String x2, String x3, OutputStream x4) throws IOException {
        return x0.writeToTar(x1, x2, x3, x4);
    }
}

