/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.copyartifact;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Hudson;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.copyartifact.Messages;
import hudson.tasks.Builder;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyArtifact
extends Builder {
    private String projectName;
    private final String filter;
    private final String target;
    private final Boolean stable;

    @DataBoundConstructor
    public CopyArtifact(String projectName, String filter, String target, boolean stable) {
        this.projectName = projectName;
        this.filter = Util.fixNull((String)filter).trim();
        this.target = Util.fixNull((String)target).trim();
        this.stable = stable ? Boolean.TRUE : null;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getFilter() {
        return this.filter;
    }

    public String getTarget() {
        return this.target;
    }

    public boolean isStable() {
        return this.stable != null ? this.stable : false;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException {
        Run run;
        PrintStream console = listener.getLogger();
        Job job = (Job)Hudson.getInstance().getItemByFullName(this.projectName, Job.class);
        if (job == null) {
            console.println(Messages.CopyArtifact_MissingProject((Object)this.projectName));
            return false;
        }
        Run run2 = run = this.stable != null && this.stable != false ? job.getLastStableBuild() : job.getLastSuccessfulBuild();
        if (run == null) {
            console.println(Messages.CopyArtifact_MissingBuild((Object)this.projectName));
            return false;
        }
        File srcDir = run.getArtifactsDir();
        FilePath targetDir = build.getWorkspace();
        if (targetDir == null) {
            console.println(Messages.CopyArtifact_MissingWorkspace());
            return false;
        }
        String expandedFilter = this.filter;
        try {
            EnvVars env = build.getEnvironment((TaskListener)listener);
            if (this.target.length() > 0) {
                targetDir = new FilePath(targetDir, env.expand(this.target));
            }
            if ((expandedFilter = build.getEnvironment((TaskListener)listener).expand(this.filter)).trim().length() == 0) {
                expandedFilter = "**";
            }
            int cnt = new FilePath(srcDir).copyRecursiveTo(expandedFilter, targetDir);
            listener.getLogger().println(Messages.CopyArtifact_Copied((Object)cnt, (Object)this.projectName));
        }
        catch (IOException ex) {
            Util.displayIOException((IOException)ex, (TaskListener)listener);
            ex.printStackTrace(listener.error(Messages.CopyArtifact_FailedToCopy((Object)this.projectName, (Object)expandedFilter)));
            return false;
        }
        return true;
    }

    static /* synthetic */ String access$002(CopyArtifact x0, String x1) {
        x0.projectName = x1;
        return x0.projectName;
    }
}

