/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.copyartifact;

import com.thoughtworks.xstream.converters.UnmarshallingContext;
import hudson.DescriptorExtensionList;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.diagnosis.OldDataMonitor;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixProject;
import hudson.matrix.MatrixRun;
import hudson.maven.MavenBuild;
import hudson.maven.MavenModuleSet;
import hudson.maven.MavenModuleSetBuild;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Project;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.ItemListener;
import hudson.plugins.copyartifact.BuildSelector;
import hudson.plugins.copyartifact.CopyMethod;
import hudson.plugins.copyartifact.Messages;
import hudson.plugins.copyartifact.StatusBuildSelector;
import hudson.plugins.copyartifact.WorkspaceSelector;
import hudson.security.AccessControlled;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.DescribableList;
import hudson.util.FormValidation;
import hudson.util.XStream2;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyArtifact
extends Builder {
    private String projectName;
    private final String filter;
    private final String target;
    private BuildSelector selector;
    @Deprecated
    private transient Boolean stable;
    private final Boolean flatten;
    private final Boolean optional;

    @DataBoundConstructor
    public CopyArtifact(String projectName, BuildSelector selector, String filter, String target, boolean flatten, boolean optional) {
        this.projectName = projectName;
        this.selector = selector;
        this.filter = Util.fixNull((String)filter).trim();
        this.target = Util.fixNull((String)target).trim();
        this.flatten = flatten ? Boolean.TRUE : null;
        this.optional = optional ? Boolean.TRUE : null;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public BuildSelector getBuildSelector() {
        return this.selector;
    }

    public String getFilter() {
        return this.filter;
    }

    public String getTarget() {
        return this.target;
    }

    public boolean isFlatten() {
        return this.flatten != null && this.flatten != false;
    }

    public boolean isOptional() {
        return this.optional != null && this.optional != false;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException {
        PrintStream console = listener.getLogger();
        String expandedProject = this.projectName;
        String expandedFilter = this.filter;
        try {
            FilePath targetDir;
            EnvVars env = build.getEnvironment((TaskListener)listener);
            env.overrideAll(build.getBuildVariables());
            expandedProject = env.expand(this.projectName);
            Job job = (Job)Hudson.getInstance().getItemByFullName(expandedProject, Job.class);
            if (job == null) {
                console.println(Messages.CopyArtifact_MissingProject(expandedProject));
                return false;
            }
            Run<?, ?> run = this.selector.getBuild(job, env);
            if (run == null) {
                console.println(Messages.CopyArtifact_MissingBuild(expandedProject));
                return this.isOptional();
            }
            FilePath baseTargetDir = targetDir = build.getWorkspace();
            if (targetDir == null) {
                console.println(Messages.CopyArtifact_MissingWorkspace());
                return this.isOptional();
            }
            if (this.target.length() > 0) {
                targetDir = new FilePath(targetDir, env.expand(this.target));
            }
            if ((expandedFilter = env.expand(this.filter)).trim().length() == 0) {
                expandedFilter = "**";
            }
            CopyMethod copier = (CopyMethod)Hudson.getInstance().getExtensionList(CopyMethod.class).get(0);
            if (run instanceof MavenModuleSetBuild) {
                boolean ok = false;
                for (MavenBuild r : ((MavenModuleSetBuild)run).getModuleLastBuilds().values()) {
                    ok |= this.perform((Run)r, expandedFilter, targetDir, baseTargetDir, copier, console);
                }
                return ok;
            }
            if (run instanceof MatrixBuild) {
                boolean ok = false;
                for (MatrixRun r : ((MatrixBuild)run).getRuns()) {
                    ok |= this.perform((Run)r, expandedFilter, targetDir.child(r.getParent().getName()), baseTargetDir, copier, console);
                }
                return ok;
            }
            return this.perform(run, expandedFilter, targetDir, baseTargetDir, copier, console);
        }
        catch (IOException ex) {
            Util.displayIOException((IOException)ex, (TaskListener)listener);
            ex.printStackTrace(listener.error(Messages.CopyArtifact_FailedToCopy(expandedProject, expandedFilter)));
            return false;
        }
    }

    private boolean perform(Run run, String expandedFilter, FilePath targetDir, FilePath baseTargetDir, CopyMethod copier, PrintStream console) throws IOException, InterruptedException {
        int cnt;
        FilePath srcDir;
        FilePath filePath = srcDir = this.selector instanceof WorkspaceSelector && run instanceof AbstractBuild ? ((AbstractBuild)run).getWorkspace() : new FilePath(run.getArtifactsDir());
        if (srcDir == null) {
            console.println(Messages.CopyArtifact_MissingWorkspace());
            return this.isOptional();
        }
        copier.init(srcDir, baseTargetDir);
        if (!this.isFlatten()) {
            cnt = copier.copyAll(srcDir, expandedFilter, targetDir);
        } else {
            FilePath[] list;
            targetDir.mkdirs();
            for (FilePath file : list = srcDir.list(expandedFilter)) {
                copier.copyOne(file, new FilePath(targetDir, file.getName()));
            }
            cnt = list.length;
        }
        console.println(Messages.CopyArtifact_Copied(cnt, run.getFullDisplayName()));
        return cnt > 0 || this.isOptional();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class ListenerImpl
    extends ItemListener {
        public void onRenamed(Item item, String oldName, String newName) {
            for (AbstractProject project : Hudson.getInstance().getAllItems(AbstractProject.class)) {
                for (CopyArtifact ca : ListenerImpl.getCopiers(project)) {
                    try {
                        if (ca.getProjectName().equals(oldName)) {
                            ca.projectName = newName;
                        } else {
                            if (!ca.getProjectName().startsWith(oldName + '/')) continue;
                            ca.projectName = newName + ca.projectName.substring(oldName.length());
                        }
                        project.save();
                    }
                    catch (IOException ex) {
                        Logger.getLogger(ListenerImpl.class.getName()).log(Level.WARNING, "Failed to resave project " + project.getName() + " for project rename in CopyArtifact build step (" + oldName + " =>" + newName + ")", ex);
                    }
                }
            }
        }

        private static List<CopyArtifact> getCopiers(AbstractProject project) {
            DescribableList list;
            Object object = project instanceof Project ? ((Project)project).getBuildersList() : (list = project instanceof MatrixProject ? ((MatrixProject)project).getBuildersList() : null);
            if (list == null) {
                return Collections.emptyList();
            }
            return list.getAll(CopyArtifact.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public FormValidation doCheckProjectName(@AncestorInPath AccessControlled anc, @QueryParameter String value) {
            if (!anc.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            Item item = Hudson.getInstance().getItemByFullName(value, Job.class);
            FormValidation result = item != null ? (item instanceof MavenModuleSet ? FormValidation.warning((String)Messages.CopyArtifact_MavenProject()) : (item instanceof MatrixProject ? FormValidation.warning((String)Messages.CopyArtifact_MatrixProject()) : FormValidation.ok())) : (value.indexOf(36) >= 0 ? FormValidation.warning((String)Messages.CopyArtifact_ParameterizedName()) : FormValidation.error((String)hudson.tasks.Messages.BuildTrigger_NoSuchProject((Object)value, (Object)AbstractProject.findNearest((String)value).getName())));
            return result;
        }

        public boolean isApplicable(Class<? extends AbstractProject> clazz) {
            return true;
        }

        public String getDisplayName() {
            return Messages.CopyArtifact_DisplayName();
        }

        public DescriptorExtensionList<BuildSelector, Descriptor<BuildSelector>> getBuildSelectors() {
            return Hudson.getInstance().getDescriptorList(BuildSelector.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ConverterImpl
    extends XStream2.PassthruConverter<CopyArtifact> {
        public ConverterImpl(XStream2 xstream) {
            super(xstream);
        }

        protected void callback(CopyArtifact obj, UnmarshallingContext context) {
            if (obj.selector == null) {
                obj.selector = new StatusBuildSelector(obj.stable != null && obj.stable != false);
                OldDataMonitor.report((UnmarshallingContext)context, (String)"1.355");
            }
        }
    }
}

