/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.copyartifact;

import hudson.Extension;
import hudson.FilePath;
import hudson.PluginWrapper;
import hudson.model.Hudson;
import hudson.plugins.copyartifact.CopyMethod;
import java.io.File;
import java.io.IOException;
import java.net.URL;

@Extension(ordinal=-100.0)
public class FilePathCopyMethod
implements CopyMethod {
    public void init(FilePath srcDir, FilePath baseTargetDir) throws IOException, InterruptedException {
        PluginWrapper pw = Hudson.getInstance().getPluginManager().getPlugin("copyartifact");
        if (pw == null) {
            System.out.println("foo");
            return;
        }
        URL base = pw.baseResourceURL;
        if (base != null && "file".equals(base.getProtocol())) {
            FilePath tmp = baseTargetDir.createTempDir("copyartifact", ".dir");
            new FilePath(new File(base.getPath())).copyRecursiveTo("HUDSON-5977/**", tmp);
            tmp.deleteRecursive();
        }
    }

    public int copyAll(FilePath srcDir, String filter, FilePath targetDir) throws IOException, InterruptedException {
        return srcDir.copyRecursiveTo(filter, targetDir);
    }

    public void copyOne(FilePath source, FilePath target) throws IOException, InterruptedException {
        source.copyTo(target);
    }
}

