/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.copyartifact;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Hudson;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.copyartifact.BuildSelector;
import hudson.plugins.copyartifact.Messages;
import hudson.tasks.Builder;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyArtifact
extends Builder {
    private String projectName;
    private final String filter;
    private final String target;
    private BuildSelector selector;
    @Deprecated
    private transient Boolean stable;
    private final Boolean flatten;
    private final Boolean optional;

    @DataBoundConstructor
    public CopyArtifact(String projectName, BuildSelector selector, String filter, String target, boolean flatten, boolean optional) {
        this.projectName = projectName;
        this.selector = selector;
        this.filter = Util.fixNull((String)filter).trim();
        this.target = Util.fixNull((String)target).trim();
        this.flatten = flatten ? Boolean.TRUE : null;
        this.optional = optional ? Boolean.TRUE : null;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public BuildSelector getBuildSelector() {
        return this.selector;
    }

    public String getFilter() {
        return this.filter;
    }

    public String getTarget() {
        return this.target;
    }

    public boolean isFlatten() {
        return this.flatten != null && this.flatten != false;
    }

    public boolean isOptional() {
        return this.optional != null && this.optional != false;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException {
        PrintStream console = listener.getLogger();
        String expandedProject = this.projectName;
        String expandedFilter = this.filter;
        try {
            int cnt;
            EnvVars env = build.getEnvironment((TaskListener)listener);
            env.overrideAll(build.getBuildVariables());
            expandedProject = env.expand(this.projectName);
            Job job = (Job)Hudson.getInstance().getItemByFullName(expandedProject, Job.class);
            if (job == null) {
                console.println(Messages.CopyArtifact_MissingProject((Object)expandedProject));
                return false;
            }
            Run run = this.selector.getBuild(job);
            if (run == null) {
                console.println(Messages.CopyArtifact_MissingBuild((Object)expandedProject));
                return this.isOptional();
            }
            File srcDir = run.getArtifactsDir();
            FilePath targetDir = build.getWorkspace();
            if (targetDir == null) {
                console.println(Messages.CopyArtifact_MissingWorkspace());
                return this.isOptional();
            }
            URL base = Hudson.getInstance().getPluginManager().getPlugin((String)"copyartifact").baseResourceURL;
            if (base != null && "file".equals(base.getProtocol())) {
                FilePath tmp = targetDir.createTempDir("copyartifact", ".dir");
                new FilePath(new File(base.getPath())).copyRecursiveTo("HUDSON-5977/**", tmp);
                tmp.deleteRecursive();
            }
            if (this.target.length() > 0) {
                targetDir = new FilePath(targetDir, env.expand(this.target));
            }
            if ((expandedFilter = env.expand(this.filter)).trim().length() == 0) {
                expandedFilter = "**";
            }
            if (!this.isFlatten()) {
                cnt = new FilePath(srcDir).copyRecursiveTo(expandedFilter, targetDir);
            } else {
                FilePath[] list;
                targetDir.mkdirs();
                for (FilePath file : list = new FilePath(srcDir).list(expandedFilter)) {
                    file.copyTo(new FilePath(targetDir, file.getName()));
                }
                cnt = list.length;
            }
            listener.getLogger().println(Messages.CopyArtifact_Copied((Object)cnt, (Object)run.getFullDisplayName()));
            return cnt > 0 || this.isOptional();
        }
        catch (IOException ex) {
            Util.displayIOException((IOException)ex, (TaskListener)listener);
            ex.printStackTrace(listener.error(Messages.CopyArtifact_FailedToCopy((Object)expandedProject, (Object)expandedFilter)));
            return false;
        }
    }

    static /* synthetic */ BuildSelector access$000(CopyArtifact x0) {
        return x0.selector;
    }

    static /* synthetic */ BuildSelector access$002(CopyArtifact x0, BuildSelector x1) {
        x0.selector = x1;
        return x0.selector;
    }

    static /* synthetic */ Boolean access$100(CopyArtifact x0) {
        return x0.stable;
    }

    static /* synthetic */ String access$202(CopyArtifact x0, String x1) {
        x0.projectName = x1;
        return x0.projectName;
    }

    static /* synthetic */ String access$200(CopyArtifact x0) {
        return x0.projectName;
    }
}

