// CHECKSTYLE:OFF

package hudson.plugins.copyartifact;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;

@SuppressWarnings({
    "",
    "PMD"
})
public class Messages {

    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Specific build
     * 
     */
    public static String SpecificBuildSelector_DisplayName() {
        return holder.format("SpecificBuildSelector.DisplayName");
    }

    /**
     * Specific build
     * 
     */
    public static Localizable _SpecificBuildSelector_DisplayName() {
        return new Localizable(holder, "SpecificBuildSelector.DisplayName");
    }

    /**
     * Latest saved build (marked "keep forever")
     * 
     */
    public static String SavedBuildSelector_DisplayName() {
        return holder.format("SavedBuildSelector.DisplayName");
    }

    /**
     * Latest saved build (marked "keep forever")
     * 
     */
    public static Localizable _SavedBuildSelector_DisplayName() {
        return new Localizable(holder, "SavedBuildSelector.DisplayName");
    }

    /**
     * Unable to find a build for artifact copy from: {0}
     * 
     */
    public static String CopyArtifact_MissingBuild(Object arg1) {
        return holder.format("CopyArtifact.MissingBuild", arg1);
    }

    /**
     * Unable to find a build for artifact copy from: {0}
     * 
     */
    public static Localizable _CopyArtifact_MissingBuild(Object arg1) {
        return new Localizable(holder, "CopyArtifact.MissingBuild", arg1);
    }

    /**
     * Unable to find project for artifact copy: {0}
     * 
     */
    public static String CopyArtifact_MissingProject(Object arg1) {
        return holder.format("CopyArtifact.MissingProject", arg1);
    }

    /**
     * Unable to find project for artifact copy: {0}
     * 
     */
    public static Localizable _CopyArtifact_MissingProject(Object arg1) {
        return new Localizable(holder, "CopyArtifact.MissingProject", arg1);
    }

    /**
     * Copied {0} {0,choice,0#artifacts|1#artifact|1&lt;artifacts} from {1}
     * 
     */
    public static String CopyArtifact_Copied(Object arg1, Object arg2) {
        return holder.format("CopyArtifact.Copied", arg1, arg2);
    }

    /**
     * Copied {0} {0,choice,0#artifacts|1#artifact|1&lt;artifacts} from {1}
     * 
     */
    public static Localizable _CopyArtifact_Copied(Object arg1, Object arg2) {
        return new Localizable(holder, "CopyArtifact.Copied", arg1, arg2);
    }

    /**
     * Value references a build parameter, so it cannot be validated.
     * 
     */
    public static String CopyArtifact_ParameterizedName() {
        return holder.format("CopyArtifact.ParameterizedName");
    }

    /**
     * Value references a build parameter, so it cannot be validated.
     * 
     */
    public static Localizable _CopyArtifact_ParameterizedName() {
        return new Localizable(holder, "CopyArtifact.ParameterizedName");
    }

    /**
     * Copy artifacts from another project
     * 
     */
    public static String CopyArtifact_DisplayName() {
        return holder.format("CopyArtifact.DisplayName");
    }

    /**
     * Copy artifacts from another project
     * 
     */
    public static Localizable _CopyArtifact_DisplayName() {
        return new Localizable(holder, "CopyArtifact.DisplayName");
    }

    /**
     * Build selector for Copy Artifact
     * 
     */
    public static String BuildSelectorParameter_DisplayName() {
        return holder.format("BuildSelectorParameter.DisplayName");
    }

    /**
     * Build selector for Copy Artifact
     * 
     */
    public static Localizable _BuildSelectorParameter_DisplayName() {
        return new Localizable(holder, "BuildSelectorParameter.DisplayName");
    }

    /**
     * Specified by a build parameter
     * 
     */
    public static String ParameterizedBuildSelector_DisplayName() {
        return holder.format("ParameterizedBuildSelector.DisplayName");
    }

    /**
     * Specified by a build parameter
     * 
     */
    public static Localizable _ParameterizedBuildSelector_DisplayName() {
        return new Localizable(holder, "ParameterizedBuildSelector.DisplayName");
    }

    /**
     * Failed to copy artifacts from {0} with filter: {1}
     * 
     */
    public static String CopyArtifact_FailedToCopy(Object arg1, Object arg2) {
        return holder.format("CopyArtifact.FailedToCopy", arg1, arg2);
    }

    /**
     * Failed to copy artifacts from {0} with filter: {1}
     * 
     */
    public static Localizable _CopyArtifact_FailedToCopy(Object arg1, Object arg2) {
        return new Localizable(holder, "CopyArtifact.FailedToCopy", arg1, arg2);
    }

    /**
     * Unable to access workspace for artifact copy. Slave node offline?
     * 
     */
    public static String CopyArtifact_MissingWorkspace() {
        return holder.format("CopyArtifact.MissingWorkspace");
    }

    /**
     * Unable to access workspace for artifact copy. Slave node offline?
     * 
     */
    public static Localizable _CopyArtifact_MissingWorkspace() {
        return new Localizable(holder, "CopyArtifact.MissingWorkspace");
    }

    /**
     * Latest successful build
     * 
     */
    public static String StatusBuildSelector_DisplayName() {
        return holder.format("StatusBuildSelector.DisplayName");
    }

    /**
     * Latest successful build
     * 
     */
    public static Localizable _StatusBuildSelector_DisplayName() {
        return new Localizable(holder, "StatusBuildSelector.DisplayName");
    }

}
