/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.copyartifact;

import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.SimpleParameterDefinition;
import hudson.model.StringParameterValue;
import hudson.plugins.copyartifact.BuildSelector;
import hudson.plugins.copyartifact.Messages;
import hudson.util.XStream2;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class BuildSelectorParameter
extends SimpleParameterDefinition {
    private BuildSelector defaultSelector;
    private static final XStream2 XSTREAM = new XStream2();

    @DataBoundConstructor
    public BuildSelectorParameter(String name, BuildSelector defaultSelector, String description) {
        super(name, description);
        this.defaultSelector = defaultSelector;
    }

    public BuildSelector getDefaultSelector() {
        return this.defaultSelector;
    }

    public ParameterValue getDefaultParameterValue() {
        return this.toStringValue(this.defaultSelector);
    }

    public ParameterValue createValue(String value) {
        BuildSelectorParameter.getSelectorFromXml(value);
        return new StringParameterValue(this.getName(), value, this.getDescription());
    }

    public ParameterValue createValue(StaplerRequest req, JSONObject jo) {
        return this.toStringValue((BuildSelector)req.bindJSON(BuildSelector.class, jo));
    }

    private StringParameterValue toStringValue(BuildSelector selector) {
        return new StringParameterValue(this.getName(), XSTREAM.toXML((Object)selector), this.getDescription());
    }

    public static BuildSelector getSelectorFromXml(String xml) {
        return (BuildSelector)XSTREAM.fromXML(xml);
    }

    static void initAliases() {
        for (Descriptor d : ((DescriptorImpl)Hudson.getInstance().getDescriptorByType(DescriptorImpl.class)).getBuildSelectors()) {
            XSTREAM.alias(d.clazz.getSimpleName(), d.clazz);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends ParameterDefinition.ParameterDescriptor {
        public String getDisplayName() {
            return Messages.BuildSelectorParameter_DisplayName();
        }

        public DescriptorExtensionList<BuildSelector, Descriptor<BuildSelector>> getBuildSelectors() {
            return Hudson.getInstance().getDescriptorList(BuildSelector.class);
        }
    }
}

