/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.covcomplplot;

import com.thoughtworks.xstream.XStream;
import hudson.XmlFile;
import hudson.model.AbstractBuild;
import hudson.plugins.covcomplplot.CovComplPlotMethods;
import hudson.plugins.covcomplplot.annalyzer.Analyzer;
import hudson.plugins.covcomplplot.model.MethodInfo;
import hudson.plugins.covcomplplot.util.CustomGraph;
import hudson.plugins.covcomplplot.util.ScatterPlotPointMapRenderer;
import hudson.plugins.covcomplplot.util.ScatterPlotPointRenderer;
import hudson.util.XStream2;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYDotRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.DefaultXYZDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CovComplPlotTaget
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient int[][] methodOccuranceMatrix;
    private transient List[][] methodMapMatrix;
    private transient String graphMapWithBuildNo = null;
    private transient String graphMap = null;
    private final Calendar ownerTimestamp;
    private final List<MethodInfo> methodInfoList;
    private transient AbstractBuild<?, ?> owner;
    private final Analyzer analyzer;
    public Object lock = new Object();

    public AbstractBuild<?, ?> getOwner() {
        return this.owner;
    }

    public CovComplPlotTaget(AbstractBuild<?, ?> owner, List<MethodInfo> methodInfoList, Analyzer analyzer, Calendar ownersTimeStamp) {
        this.owner = owner;
        this.methodInfoList = methodInfoList;
        this.analyzer = analyzer;
        this.ownerTimestamp = ownersTimeStamp;
    }

    public String getMethodUrlLocation(MethodInfo methodInfo) {
        return this.analyzer.getHandler().getMethodUrlLocation(this.owner, methodInfo);
    }

    public GraphImpl getGraph() {
        return new GraphImpl();
    }

    public void doDynamic(StaplerRequest req, StaplerResponse rsp, @QueryParameter(value="cov") int cov, @QueryParameter(value="compl") int compl, @QueryParameter(value="page") int page) throws ServletException, IOException {
        page = Math.max(page, 1);
        cov = Math.min(cov, 9);
        compl = Math.min(compl, 6);
        List[][] methodMapMatrix = this.createMapGridMatrix(this.getMethodInfoList());
        List<MethodInfo> obj = methodMapMatrix[compl][cov];
        int totalSize = 0;
        if (obj == null) {
            obj = Collections.emptyList();
        } else {
            totalSize = obj.size();
            int startIndex = (page - 1) * 20;
            int retrieveSize = Math.min(totalSize - (page - 1) * 20, 20);
            obj = obj.subList(startIndex, startIndex + retrieveSize);
        }
        req.getView((Object)new CovComplPlotMethods(this.owner, obj, this.analyzer, cov, compl, page, totalSize), "index.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[][] createMatrix(List<MethodInfo> methodInfoList) {
        Object object = this.lock;
        synchronized (object) {
            if (this.methodOccuranceMatrix == null) {
                int[][] matrix = new int[35][100];
                for (MethodInfo methodInfo : methodInfoList) {
                    int complexityIndex = Math.min(methodInfo.compl, 34);
                    int coverageIndex = Math.min(Math.round(methodInfo.getCoverageRatio()), 99);
                    int[] nArray = matrix[complexityIndex];
                    int n = coverageIndex;
                    nArray[n] = nArray[n] + 1;
                }
                this.methodOccuranceMatrix = matrix;
            }
        }
        return this.methodOccuranceMatrix;
    }

    public String getDescription() {
        return this.analyzer.getHandler().getDescription();
    }

    private int getSnapValue(double x, int snap) {
        return (int)(x / (double)snap) * snap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List[][] createMapGridMatrix(List<MethodInfo> methodInfoList) {
        Object object = this.lock;
        synchronized (object) {
            if (this.methodMapMatrix == null) {
                ArrayList[][] matrix = new ArrayList[7][10];
                for (MethodInfo methodInfo : methodInfoList) {
                    int coverageIndex;
                    int complexityIndex = Math.min(this.getSnapValue(methodInfo.compl, 5), 30) / 5;
                    ArrayList<MethodInfo> each = matrix[complexityIndex][coverageIndex = Math.min(this.getSnapValue(methodInfo.getCoverageRatio(), 10), 90) / 10];
                    if (each == null) {
                        each = new ArrayList<MethodInfo>();
                    }
                    matrix[complexityIndex][coverageIndex] = each;
                    each.add(methodInfo);
                }
                ArrayList[][] arr$ = matrix;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    ArrayList[] matrixRow;
                    for (ArrayList matrixCol : matrixRow = arr$[i$]) {
                        if (matrixCol == null) continue;
                        Collections.sort(matrixCol);
                    }
                }
                this.methodMapMatrix = matrix;
            }
        }
        return this.methodMapMatrix;
    }

    public DefaultXYZDataset generateXYDataset() {
        this.methodOccuranceMatrix = this.createMatrix(this.getMethodInfoList());
        DefaultXYZDataset dataSet = new DefaultXYZDataset();
        int totalPoint = 0;
        int[][] arr$ = this.methodOccuranceMatrix;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int[] eachRow;
            for (int eachValue : eachRow = arr$[i$]) {
                if (eachValue == 0) continue;
                ++totalPoint;
            }
        }
        double[][] eachPoint = new double[3][totalPoint];
        int count = 0;
        for (int eachRowCount = 0; eachRowCount < this.methodOccuranceMatrix.length; ++eachRowCount) {
            for (int eachColumCount = 0; eachColumCount < this.methodOccuranceMatrix[eachRowCount].length; ++eachColumCount) {
                int methodCount = this.methodOccuranceMatrix[eachRowCount][eachColumCount];
                if (methodCount == 0) continue;
                eachPoint[0][count] = eachColumCount;
                eachPoint[1][count] = eachRowCount;
                eachPoint[2][count] = methodCount;
                ++count;
            }
        }
        dataSet.addSeries((Comparable)Integer.valueOf(1), eachPoint);
        return dataSet;
    }

    public void setOwner(AbstractBuild<?, ?> owner) {
        this.owner = owner;
    }

    private static XmlFile getDataFile(AbstractBuild<?, ?> build) {
        File dir = build == null ? new File(System.getProperty("java.io.tmpdir")) : build.getRootDir();
        return new XmlFile((XStream)new XStream2(), new File(dir, "covcomplplot.xml"));
    }

    public static CovComplPlotTaget loadCloverScatterPlotTarget(AbstractBuild<?, ?> build) throws IOException {
        CovComplPlotTaget target = (CovComplPlotTaget)CovComplPlotTaget.getDataFile(build).read();
        target.setOwner(build);
        return target;
    }

    public static void saveCloverScatterPlotTarget(AbstractBuild<?, ?> build, CovComplPlotTaget target) throws IOException {
        CovComplPlotTaget.getDataFile(build).write((Object)target);
    }

    public List<MethodInfo> getMethodInfoList() {
        return this.methodInfoList;
    }

    public class GraphImpl
    extends CustomGraph {
        XYDotRenderer renderer;
        public final long timeInMillis;

        protected GraphImpl() {
            super(CovComplPlotTaget.this.ownerTimestamp, 500, 200);
            this.renderer = null;
            this.timeInMillis = CovComplPlotTaget.this.ownerTimestamp.getTimeInMillis();
        }

        public void doPng(StaplerRequest req, StaplerResponse rsp) throws IOException {
            this.renderer = new ScatterPlotPointRenderer();
            super.doPng(req, rsp);
        }

        public synchronized String getMapString(String withBuildNo) {
            if ("true".equals(withBuildNo)) {
                if (CovComplPlotTaget.this.graphMapWithBuildNo == null) {
                    CovComplPlotTaget.this.graphMapWithBuildNo = this.getMapString(withBuildNo, null);
                }
                return CovComplPlotTaget.this.graphMapWithBuildNo;
            }
            if (CovComplPlotTaget.this.graphMap == null) {
                CovComplPlotTaget.this.graphMap = this.getMapString(withBuildNo, null);
            }
            return CovComplPlotTaget.this.graphMap;
        }

        private String getMapString(String withBuildNo, StaplerRequest req) {
            this.renderer = new ScatterPlotPointMapRenderer();
            ChartRenderingInfo info = new ChartRenderingInfo();
            this.render(req, info);
            Rectangle2D dataArea = ((ScatterPlotPointMapRenderer)this.renderer).dataArea;
            XYPlot xyPlot = this.graph.getXYPlot();
            ValueAxis domainAxis = xyPlot.getDomainAxis();
            ValueAxis rangeAxis = xyPlot.getRangeAxis();
            double rangeTickSize = dataArea.getHeight() / 7.0;
            double domainTickSize = dataArea.getWidth() / 10.0;
            RectangleEdge domainAxisEdge = xyPlot.getDomainAxisEdge();
            RectangleEdge rangeAxisEdge = xyPlot.getRangeAxisEdge();
            int buildNo = ((CovComplPlotTaget)CovComplPlotTaget.this).owner.number;
            List[][] mapGridMatrix = CovComplPlotTaget.this.createMapGridMatrix(CovComplPlotTaget.this.getMethodInfoList());
            for (int x = 0; x < 10; ++x) {
                for (int y = 0; y < 7; ++y) {
                    if (mapGridMatrix[y][x] == null) continue;
                    int valueX = x * 10;
                    int valueY = y * 5;
                    double realX = domainAxis.valueToJava2D((double)valueX, dataArea, domainAxisEdge);
                    double realY = rangeAxis.valueToJava2D((double)valueY, dataArea, rangeAxisEdge);
                    String complexityRangeString = "";
                    complexityRangeString = valueY == 34 ? String.format("%d~", valueY) : String.format("%d~%d", valueY, valueY + 5 - 1);
                    String tooltip = String.format("%d methods - Complexity : %s, Coverage : %d~%d%%", mapGridMatrix[y][x].size(), complexityRangeString, valueX, valueX + 10 - 1);
                    String url = String.format("%s/?cov=%d&compl=%d", "covcomplplot", x, y);
                    if ("true".equals(withBuildNo)) {
                        url = buildNo + "/" + url;
                    }
                    info.getEntityCollection().add(new ChartEntity((Shape)new Rectangle((int)realX, (int)(realY - rangeTickSize), (int)domainTickSize - 1, (int)rangeTickSize - 1), tooltip, url));
                }
            }
            String mapString = ChartUtilities.getImageMap((String)"covcomplmap", (ChartRenderingInfo)info);
            return mapString;
        }

        protected JFreeChart createGraph() {
            DefaultXYZDataset dataset = CovComplPlotTaget.this.generateXYDataset();
            JFreeChart chart = ChartFactory.createScatterPlot((String)"", (String)"coverage(%)", (String)"complexity", (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
            chart.setBackgroundPaint((Paint)Color.white);
            XYPlot plot = chart.getXYPlot();
            plot.setBackgroundPaint((Paint)Color.WHITE);
            plot.setOutlinePaint(null);
            plot.setForegroundAlpha(0.4f);
            plot.setRangeGridlinesVisible(true);
            plot.setRangeGridlinePaint((Paint)Color.GRAY);
            plot.setRangeGridlinesVisible(true);
            plot.setDomainGridlinePaint((Paint)Color.GRAY);
            plot.setAxisOffset(new RectangleInsets(0.0, 0.0, 0.0, 0.0));
            ValueAxis rangeAxis = plot.getRangeAxis();
            rangeAxis.setAutoRange(false);
            rangeAxis.setUpperBound(35.0);
            rangeAxis.setLowerBound(0.0);
            ((NumberAxis)rangeAxis).setTickUnit(new NumberTickUnit(5.0));
            ValueAxis domainAxis = plot.getDomainAxis();
            domainAxis.setAutoRange(false);
            domainAxis.setUpperBound(100.0);
            domainAxis.setLowerBound(0.0);
            ((NumberAxis)domainAxis).setTickUnit(new NumberTickUnit(10.0));
            plot.setInsets(new RectangleInsets(5.0, 0.0, 0.0, 10.0));
            this.renderer.setSeriesPaint(0, (Paint)Color.BLUE);
            plot.setRenderer((XYItemRenderer)this.renderer);
            return chart;
        }
    }
}

