/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.covcomplplot.model;

import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.text.DecimalFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodInfo
implements Comparable<MethodInfo> {
    @XStreamAsAttribute
    public final String sig;
    @XStreamAsAttribute
    public final int compl;
    @XStreamAsAttribute
    public final int line;
    @XStreamAsAttribute
    public int cst;
    @XStreamAsAttribute
    public int st;
    @XStreamAsAttribute
    public final String path;
    public static DecimalFormat formatter = new DecimalFormat("#.##");

    public MethodInfo(String path, String signature, int complexity, int lineno) {
        this.path = path;
        this.sig = signature;
        this.compl = complexity;
        this.line = lineno;
    }

    public float getCoverageRatio() {
        if (this.st == 0) {
            return Float.NaN;
        }
        return (float)this.cst / (float)this.st * 100.0f;
    }

    public String getFormattedCoverageRatio() {
        float ratio = this.getCoverageRatio();
        return ratio == Float.NaN ? "0" : formatter.format(ratio);
    }

    public String getDisplaySignature() {
        if (this.sig.length() > 80) {
            return this.sig.substring(0, 77) + "...";
        }
        return this.sig;
    }

    public void increaseLine(boolean covered) {
        if (covered) {
            ++this.cst;
        }
        ++this.st;
    }

    public String toString() {
        return String.format("%s -- %s, %d, %d / %d, %d", this.path, this.sig, this.line, this.cst, this.st, (int)((float)this.cst / (float)this.st * 100.0f));
    }

    @Override
    public int compareTo(MethodInfo o) {
        int compare = o.compl - this.compl;
        if (compare == 0) {
            compare = o.st - this.st;
        }
        return compare;
    }
}

