/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.covcomplplot.util;

import java.awt.HeadlessException;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Calendar;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.JFreeChart;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public abstract class CustomGraph {
    protected final long timestamp;
    protected final int defaultW;
    protected final int defaultH;
    protected volatile JFreeChart graph;

    protected CustomGraph(long timestamp, int defaultW, int defaultH) {
        this.timestamp = timestamp;
        this.defaultW = defaultW;
        this.defaultH = defaultH;
    }

    protected CustomGraph(Calendar timestamp, int defaultW, int defaultH) {
        this(timestamp.getTimeInMillis(), defaultW, defaultH);
    }

    protected abstract JFreeChart createGraph();

    protected BufferedImage render(ChartRenderingInfo info) {
        if (this.graph == null) {
            this.graph = this.createGraph();
        }
        return this.graph.createBufferedImage(this.defaultW, this.defaultH, null);
    }

    protected BufferedImage render(StaplerRequest req, ChartRenderingInfo info) {
        String w = null;
        String h = null;
        if (req != null) {
            w = req.getParameter("width");
            if (w == null) {
                w = String.valueOf(this.defaultW);
            }
            if ((h = req.getParameter("height")) == null) {
                h = String.valueOf(this.defaultH);
            }
        } else {
            w = String.valueOf(this.defaultW);
            h = String.valueOf(this.defaultH);
        }
        if (this.graph == null) {
            this.graph = this.createGraph();
        }
        return this.graph.createBufferedImage(Integer.parseInt(w), Integer.parseInt(h), null);
    }

    public void doPng(StaplerRequest req, StaplerResponse rsp) throws IOException {
        if (req.checkIfModified(this.timestamp, rsp)) {
            return;
        }
        try {
            BufferedImage image = this.render(req, null);
            rsp.setContentType("image/png");
            ServletOutputStream os = rsp.getOutputStream();
            ImageIO.write((RenderedImage)image, "PNG", (OutputStream)os);
            os.close();
        }
        catch (Error e) {
            if (e.getMessage().contains("Probable fatal error:No fonts found")) {
                rsp.sendRedirect2(req.getContextPath() + "/images/headless.png");
                return;
            }
            throw e;
        }
        catch (HeadlessException e) {
            rsp.sendRedirect2(req.getContextPath() + "/images/headless.png");
        }
    }
}

