/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.covcomplplot.util;

import hudson.FilePath;
import hudson.model.Hudson;
import hudson.plugins.covcomplplot.util.NoXPathContentException;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.springframework.core.io.ClassPathResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QDUtil {
    static Pattern pattern = Pattern.compile("\\.(java|c|cpp|hpp|h|hxx|cxx)$");
    public static DocumentFactory factory = new DocumentFactory();
    public static Map<String, MessageFormat> templateCache;

    public static boolean isKlocworkRecognizedFile(String file) {
        if (file == null) {
            return false;
        }
        return pattern.matcher(file).find();
    }

    public static String getXPathNodeText(Node node, String xpathStr) throws NoXPathContentException {
        return QDUtil.getXPathNode(node, xpathStr).getText();
    }

    public static List<Element> getXPathNodeList(Node node, String xpathStr) {
        List selectNodes = node.selectNodes(xpathStr);
        return selectNodes;
    }

    public static int compareVersion(String v1, String v2) {
        String s1 = QDUtil.normalisedVersion(v1);
        String s2 = QDUtil.normalisedVersion(v2);
        return s1.compareTo(s2);
    }

    public static String normalisedVersion(String version) {
        return QDUtil.normalisedVersion(version, ".", 4);
    }

    public static String normalisedVersion(String version, String sep, int maxWidth) {
        String[] split = Pattern.compile(sep, 16).split(version);
        StringBuilder sb = new StringBuilder();
        for (String s : split) {
            sb.append(String.format("%" + maxWidth + 's', s));
        }
        return sb.toString();
    }

    public static String getClassResourcePath(Class<?> clazz, String extension) {
        return clazz.getCanonicalName().replace(".", "/").concat(".").concat(extension);
    }

    public static synchronized MessageFormat getTemplate(String location) {
        if (!templateCache.containsKey(location)) {
            try {
                ClassPathResource resource = new ClassPathResource(location, QDUtil.class.getClassLoader());
                InputStream inputStream = resource.getInputStream();
                String template = IOUtils.toString((InputStream)inputStream, (String)"UTF-8");
                MessageFormat stringTemplate = new MessageFormat(template);
                templateCache.put(location, stringTemplate);
                IOUtils.closeQuietly((InputStream)inputStream);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        MessageFormat template = templateCache.get(location);
        return template;
    }

    public static Element getXPathNode(Node node, String xpathStr) throws NoXPathContentException {
        Node selectSingleNode = node.selectSingleNode(xpathStr);
        if (selectSingleNode == null) {
            throw new NoXPathContentException(xpathStr + " is not avaliable");
        }
        return (Element)selectSingleNode;
    }

    public static Document getXmlFileDocument(InputStream stream, DocumentFactory factory) throws DocumentException {
        SAXReader reader = new SAXReader(factory);
        Document doc = reader.read(stream);
        IOUtils.closeQuietly((InputStream)stream);
        return doc;
    }

    public static Document getXmlFileDocument(InputStream stream) throws DocumentException {
        return QDUtil.getXmlFileDocument(stream, factory);
    }

    public static FilePath[] findFile(FilePath basePath, String pattern) {
        try {
            return basePath.list(pattern);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String getIcons(String iconName) {
        if (StringUtils.isEmpty((String)iconName)) {
            iconName = "blank";
        }
        return QDUtil.getPlugInDir() + "icons/" + iconName.toUpperCase() + ".gif";
    }

    public static String getPlugInDir() {
        String rootDir = "http://localhost:8080";
        try {
            rootDir = Hudson.getInstance().getRootUrlFromRequest();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rootDir + "plugin/qd/";
    }

    static {
        factory.setXPathNamespaceURIs((Map)new HashMap<String, String>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("n", "nhncorp.koreabusinesssupport.nhninformationsystem.productiongroup.QualityDashboard.getprojectcodequality");
                this.put("cl", "http://schemas.atlassian.com/clover3/report");
            }
        });
        templateCache = new HashMap<String, MessageFormat>();
    }
}

