/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.covcomplplot.annalyzer;

import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.plugins.covcomplplot.annalyzer.Analyzer;
import hudson.plugins.covcomplplot.model.MethodInfo;
import hudson.plugins.covcomplplot.stub.InvalidHudsonProjectException;
import hudson.plugins.covcomplplot.stub.InvalidHudsonProjectType;
import hudson.plugins.covcomplplot.stub.LoggerWrapper;
import hudson.plugins.covcomplplot.util.CovComplPlotUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMethodInfoHandler {
    public abstract List<MethodInfo> process(AbstractBuild<?, ?> var1, boolean var2, String var3, LoggerWrapper var4, Analyzer var5) throws InvalidHudsonProjectException;

    public Document getBuildArtifact(AbstractBuild<?, ?> build, String fileName, Analyzer forWhat) throws InvalidHudsonProjectException {
        Document document = null;
        File artifactFile = new File(build.getRootDir(), fileName);
        FileInputStream is = null;
        try {
            is = new FileInputStream(artifactFile);
            document = CovComplPlotUtil.getXmlFileDocument((InputStream)is);
        }
        catch (Exception e) {
            try {
                throw new InvalidHudsonProjectException(InvalidHudsonProjectType.INVALID_PLUGIN_RESULT, (Throwable)e, new Object[]{forWhat.getPluginName()});
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        return document;
    }

    protected boolean isMethodValid(MethodInfo method, boolean excludeGetterSetter) {
        if (method == null) {
            return true;
        }
        if (method.st == 0) {
            return false;
        }
        if (excludeGetterSetter) {
            return !this.isGetterSetter(method);
        }
        return true;
    }

    protected boolean isGetterSetter(MethodInfo method) {
        if (method.st == 1 && method.compl == 1) {
            return StringUtils.startsWithIgnoreCase((String)method.sig, (String)"get") || StringUtils.startsWithIgnoreCase((String)method.sig, (String)"set");
        }
        return false;
    }

    public String getCustomJavaScript() {
        return "";
    }

    public abstract String getMethodUrlLocation(AbstractBuild<?, ?> var1, MethodInfo var2);

    public abstract void checkBuild(AbstractBuild<?, ?> var1) throws InvalidHudsonProjectException;

    public abstract String getDescription();

    protected void checkBuildContainningBuildAction(AbstractBuild<?, ?> build, String buildActionName) throws InvalidHudsonProjectException {
        for (Action eachAction : build.getActions()) {
            if (!buildActionName.equals(eachAction.getUrlName())) continue;
            return;
        }
        throw new InvalidHudsonProjectException(InvalidHudsonProjectType.INVALID_PLUGIN_RESULT, new Object[]{Analyzer.Clover});
    }
}

