/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.covcomplplot.annalyzer;

import hudson.Functions;
import hudson.model.AbstractBuild;
import hudson.plugins.covcomplplot.annalyzer.AbstractMethodInfoHandler;
import hudson.plugins.covcomplplot.annalyzer.Analyzer;
import hudson.plugins.covcomplplot.model.MethodInfo;
import hudson.plugins.covcomplplot.stub.InvalidHudsonProjectException;
import hudson.plugins.covcomplplot.stub.LoggerWrapper;
import hudson.plugins.covcomplplot.util.CovComplPlotUtil;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloverMethodHandler
extends AbstractMethodInfoHandler {
    public List<MethodInfo> process(AbstractBuild<?, ?> build, boolean excludeGetterSetter, String remoteDir, LoggerWrapper logger, Analyzer analyzer) throws InvalidHudsonProjectException {
        Document clover = super.getBuildArtifact(build, "clover.xml", Analyzer.Clover);
        List domElement = null;
        domElement = CovComplPlotUtil.getXPathNodeList((Node)clover, (String)"/coverage/project/package");
        if (domElement.size() == 0) {
            domElement = CovComplPlotUtil.getXPathNodeList((Node)clover, (String)"/cl:coverage/cl:project/cl:package");
        }
        int maxComplexity = 0;
        ArrayList<MethodInfo> methods = new ArrayList<MethodInfo>();
        for (Element eachPackage : domElement) {
            String dirPath = eachPackage.attributeValue("name");
            for (Object eachFileObject : eachPackage.elements("file")) {
                MethodInfo lastMehodInfo;
                Element eachFileElement = (Element)eachFileObject;
                String path = dirPath.replace(".", "/") + "/" + eachFileElement.attributeValue("name");
                MethodInfo cloverMethod = null;
                for (Object each : eachFileElement.elements("line")) {
                    Element eachLine = (Element)each;
                    String eachType = eachLine.attributeValue("type");
                    if ("method".equals(eachType)) {
                        if (!this.isMethodValid(cloverMethod, excludeGetterSetter)) {
                            methods.remove(methods.size() - 1);
                        }
                        String signature = eachLine.attributeValue("signature");
                        int complexity = Integer.parseInt(eachLine.attributeValue("complexity"));
                        int lineno = Integer.parseInt(eachLine.attributeValue("num"));
                        maxComplexity = Math.max(maxComplexity, complexity);
                        cloverMethod = new MethodInfo(path, signature, complexity, lineno);
                        methods.add(cloverMethod);
                        continue;
                    }
                    if (!"stmt".equals(eachType) || cloverMethod == null) continue;
                    cloverMethod.increaseLine(!"0".equals(eachLine.attributeValue("count")));
                }
                if (methods.size() <= 0 || this.isMethodValid(lastMehodInfo = methods.get(methods.size() - 1), excludeGetterSetter)) continue;
                methods.remove(methods.size() - 1);
            }
        }
        return methods;
    }

    public String getCustomJavaScript() {
        return "";
    }

    public String getMethodUrlLocation(AbstractBuild<?, ?> owner, MethodInfo methodInfo) {
        String cloverPath = methodInfo.path;
        if (cloverPath.endsWith(".java")) {
            cloverPath = cloverPath.replaceAll("\\.java$", ".html");
        }
        return String.format("%s/clover-report/%s#%d", owner.getUrl(), Functions.encode((String)cloverPath), methodInfo.line);
    }

    public void checkBuild(AbstractBuild<?, ?> build) throws InvalidHudsonProjectException {
        this.checkBuildContainningBuildAction(build, "clover");
    }

    public String getDescription() {
        return "Clover hudson plugin result is used for generating this plot.<br/> In this case, the coverage means statement coverage.";
    }
}

