/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.covcomplplot.util;

import hudson.FilePath;
import hudson.plugins.covcomplplot.util.NoXPathContentException;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.springframework.core.io.ClassPathResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class CovComplPlotUtil {
    static Pattern pattern = Pattern.compile("\\.(java|c|cpp|hpp|h|hxx|cxx)$");
    public static DocumentFactory factory = new DocumentFactory();
    public static Map<String, MessageFormat> templateCache;

    public static String getXPathNodeText(Node node, String xpathStr) throws NoXPathContentException {
        return CovComplPlotUtil.getXPathNode((Node)node, (String)xpathStr).getText();
    }

    public static List<Element> getXPathNodeList(Node node, String xpathStr) {
        List selectNodes = node.selectNodes(xpathStr);
        return selectNodes;
    }

    public static synchronized MessageFormat getTemplate(String location) {
        if (!templateCache.containsKey(location)) {
            try {
                ClassPathResource resource = new ClassPathResource(location, CovComplPlotUtil.class.getClassLoader());
                InputStream inputStream = resource.getInputStream();
                String template = IOUtils.toString((InputStream)inputStream, (String)"UTF-8");
                MessageFormat stringTemplate = new MessageFormat(template);
                templateCache.put(location, stringTemplate);
                IOUtils.closeQuietly((InputStream)inputStream);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        MessageFormat template = (MessageFormat)templateCache.get(location);
        return template;
    }

    public static Element getXPathNode(Node node, String xpathStr) throws NoXPathContentException {
        Node selectSingleNode = node.selectSingleNode(xpathStr);
        if (selectSingleNode == null) {
            throw new NoXPathContentException(xpathStr + " is not avaliable");
        }
        return (Element)selectSingleNode;
    }

    public static Document getXmlFileDocument(InputStream stream, DocumentFactory factory) throws DocumentException {
        SAXReader reader = new SAXReader(factory);
        Document doc = reader.read(stream);
        IOUtils.closeQuietly((InputStream)stream);
        return doc;
    }

    public static Document getXmlFileDocument(InputStream stream) throws DocumentException {
        return CovComplPlotUtil.getXmlFileDocument((InputStream)stream, (DocumentFactory)factory);
    }

    public static FilePath[] findFile(FilePath basePath, String pattern) {
        try {
            return basePath.list(pattern);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return null;
    }

    static {
        factory.setXPathNamespaceURIs((Map)new /* Unavailable Anonymous Inner Class!! */);
        templateCache = new HashMap();
    }
}

