/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.covcomplplot;

import com.thoughtworks.xstream.XStream;
import hudson.XmlFile;
import hudson.model.AbstractBuild;
import hudson.plugins.covcomplplot.CovComplPlotMethods;
import hudson.plugins.covcomplplot.CovComplPlotTaget;
import hudson.plugins.covcomplplot.analyzer.Analyzer;
import hudson.plugins.covcomplplot.model.MethodInfo;
import hudson.util.XStream2;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.jfree.data.xy.DefaultXYZDataset;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class CovComplPlotTaget
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient int[][] methodOccuranceMatrix;
    private transient List[][] methodMapMatrix;
    private transient String graphMapWithBuildNo = null;
    private transient String graphMap = null;
    private final Calendar ownerTimestamp;
    private final List<MethodInfo> methodInfoList;
    private transient AbstractBuild<?, ?> owner;
    private final Analyzer analyzer;
    public Object lock = new Object();

    public AbstractBuild<?, ?> getOwner() {
        return this.owner;
    }

    public CovComplPlotTaget(AbstractBuild<?, ?> owner, List<MethodInfo> methodInfoList, Analyzer analyzer, Calendar ownersTimeStamp) {
        this.owner = owner;
        this.methodInfoList = methodInfoList;
        this.analyzer = analyzer;
        this.ownerTimestamp = ownersTimeStamp;
    }

    public GraphImpl getGraph() {
        return new GraphImpl(this);
    }

    public void doDynamic(StaplerRequest req, StaplerResponse rsp, @QueryParameter(value="cov") int cov, @QueryParameter(value="compl") int compl, @QueryParameter(value="page") int page) throws ServletException, IOException {
        page = Math.max(page, 1);
        cov = Math.min(cov, 9);
        compl = Math.min(compl, 6);
        List[][] methodMapMatrix = this.createMapGridMatrix(this.getMethodInfoList());
        List obj = methodMapMatrix[compl][cov];
        int totalSize = 0;
        if (obj == null) {
            obj = Collections.emptyList();
        } else {
            totalSize = obj.size();
            int startIndex = (page - 1) * 20;
            int retrieveSize = Math.min(totalSize - (page - 1) * 20, 20);
            obj = obj.subList(startIndex, startIndex + retrieveSize);
        }
        req.getView((Object)new CovComplPlotMethods(this.owner, obj, this.analyzer, cov, compl, page, totalSize), "index.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[][] createMatrix(List<MethodInfo> methodInfoList) {
        Object object = this.lock;
        synchronized (object) {
            if (this.methodOccuranceMatrix == null) {
                int[][] matrix = new int[35][100];
                for (MethodInfo methodInfo : methodInfoList) {
                    int complexityIndex = Math.min(methodInfo.compl, 34);
                    int coverageIndex = Math.min(Math.round(methodInfo.getCoverageRatio()), 99);
                    int[] nArray = matrix[complexityIndex];
                    int n = coverageIndex;
                    nArray[n] = nArray[n] + 1;
                }
                this.methodOccuranceMatrix = matrix;
            }
        }
        return this.methodOccuranceMatrix;
    }

    public String getCustomJavaScript() {
        return this.analyzer.getHandler().getCustomJavaScript();
    }

    public String getDescription() {
        return this.analyzer.getHandler().getDescription();
    }

    private int getSnapValue(double x, int snap) {
        return (int)(x / (double)snap) * snap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List[][] createMapGridMatrix(List<MethodInfo> methodInfoList) {
        Object object = this.lock;
        synchronized (object) {
            if (this.methodMapMatrix == null) {
                ArrayList[][] matrix = new ArrayList[7][10];
                for (MethodInfo methodInfo : methodInfoList) {
                    int coverageIndex;
                    int complexityIndex = Math.min(this.getSnapValue((double)methodInfo.compl, 5), 30) / 5;
                    ArrayList<MethodInfo> each = matrix[complexityIndex][coverageIndex = Math.min(this.getSnapValue((double)methodInfo.getCoverageRatio(), 10), 90) / 10];
                    if (each == null) {
                        each = new ArrayList<MethodInfo>();
                    }
                    matrix[complexityIndex][coverageIndex] = each;
                    each.add(methodInfo);
                }
                ArrayList[][] arr$ = matrix;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    ArrayList[] matrixRow;
                    for (ArrayList matrixCol : matrixRow = arr$[i$]) {
                        if (matrixCol == null) continue;
                        Collections.sort(matrixCol);
                    }
                }
                this.methodMapMatrix = matrix;
            }
        }
        return this.methodMapMatrix;
    }

    public DefaultXYZDataset generateXYDataset() {
        this.methodOccuranceMatrix = this.createMatrix(this.getMethodInfoList());
        DefaultXYZDataset dataSet = new DefaultXYZDataset();
        int totalPoint = 0;
        int[][] arr$ = this.methodOccuranceMatrix;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int[] eachRow;
            for (int eachValue : eachRow = arr$[i$]) {
                if (eachValue == 0) continue;
                ++totalPoint;
            }
        }
        double[][] eachPoint = new double[3][totalPoint];
        int count = 0;
        for (int eachRowCount = 0; eachRowCount < this.methodOccuranceMatrix.length; ++eachRowCount) {
            for (int eachColumCount = 0; eachColumCount < this.methodOccuranceMatrix[eachRowCount].length; ++eachColumCount) {
                int methodCount = this.methodOccuranceMatrix[eachRowCount][eachColumCount];
                if (methodCount == 0) continue;
                eachPoint[0][count] = eachColumCount;
                eachPoint[1][count] = eachRowCount;
                eachPoint[2][count] = methodCount;
                ++count;
            }
        }
        dataSet.addSeries((Comparable)Integer.valueOf(1), eachPoint);
        return dataSet;
    }

    public void setOwner(AbstractBuild<?, ?> owner) {
        this.owner = owner;
    }

    private static XmlFile getDataFile(AbstractBuild<?, ?> build) {
        File dir = build == null ? new File(System.getProperty("java.io.tmpdir")) : build.getRootDir();
        return new XmlFile((XStream)new XStream2(), new File(dir, "covcomplplot.xml"));
    }

    public static CovComplPlotTaget loadCovComplScatterPlotTarget(AbstractBuild<?, ?> build) throws IOException {
        CovComplPlotTaget target = (CovComplPlotTaget)CovComplPlotTaget.getDataFile(build).read();
        target.setOwner(build);
        return target;
    }

    public static void saveCovComplScatterPlotTarget(CovComplPlotTaget target) throws IOException {
        CovComplPlotTaget.getDataFile((AbstractBuild)target.getOwner()).write((Object)target);
    }

    public List<MethodInfo> getMethodInfoList() {
        return this.methodInfoList;
    }

    static /* synthetic */ Calendar access$000(CovComplPlotTaget x0) {
        return x0.ownerTimestamp;
    }

    static /* synthetic */ String access$100(CovComplPlotTaget x0) {
        return x0.graphMapWithBuildNo;
    }

    static /* synthetic */ String access$102(CovComplPlotTaget x0, String x1) {
        x0.graphMapWithBuildNo = x1;
        return x0.graphMapWithBuildNo;
    }

    static /* synthetic */ String access$200(CovComplPlotTaget x0) {
        return x0.graphMap;
    }

    static /* synthetic */ String access$202(CovComplPlotTaget x0, String x1) {
        x0.graphMap = x1;
        return x0.graphMap;
    }

    static /* synthetic */ AbstractBuild access$300(CovComplPlotTaget x0) {
        return x0.owner;
    }

    static /* synthetic */ List[][] access$400(CovComplPlotTaget x0, List x1) {
        return x0.createMapGridMatrix(x1);
    }
}

