/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.covcomplplot;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.plugins.covcomplplot.CovComplPlotBuildAction;
import hudson.plugins.covcomplplot.CovComplPlotProjectAction;
import hudson.plugins.covcomplplot.CovComplPlotPublisher;
import hudson.plugins.covcomplplot.CovComplPlotTaget;
import hudson.plugins.covcomplplot.analyzer.Analyzer;
import hudson.plugins.covcomplplot.model.MethodInfo;
import hudson.plugins.covcomplplot.stub.InvalidHudsonProjectException;
import hudson.plugins.covcomplplot.stub.InvalidHudsonProjectType;
import hudson.plugins.covcomplplot.stub.LoggerWrapper;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CovComplPlotPublisher
extends Notifier {
    public final Analyzer analyzer;
    public final boolean verbose;
    public final boolean excludeGetterSetter;
    private boolean locateTopMost = true;

    @DataBoundConstructor
    public CovComplPlotPublisher(Analyzer analyzer, boolean excludeGetterSetter, boolean verbose, boolean locateTopMost) {
        this.analyzer = analyzer;
        this.excludeGetterSetter = excludeGetterSetter;
        this.verbose = verbose;
        this.setLocateTopMost(locateTopMost);
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        LoggerWrapper logger = this.getLoggerWrapper(listener);
        try {
            logger.println((Object)"Collecting Data...");
            try {
                this.analyzer.getHandler().checkBuild(build);
            }
            catch (InvalidHudsonProjectException e) {
                logger.printError((Object)e.getLogMessage());
                return true;
            }
            FilePath filePath = build.getModuleRoot();
            String remoteDir = FilenameUtils.normalize((String)filePath.getRemote());
            List methods = this.getCovComplMethodInfoList(this.analyzer, build, this.excludeGetterSetter, remoteDir, logger);
            logger.println((Object)"Build CovComplPlotBuildAction...");
            CovComplPlotBuildAction buildAction = this.createCovComplScatterPlotBuildAction(build, methods);
            build.addAction((Action)buildAction);
            Action customAction = this.analyzer.getHandler().getCustomSourceViewBuildAction(build);
            if (customAction != null) {
                build.addAction(customAction);
            }
            logger.println((Object)"Complete CovCompPlotPlugIn.");
        }
        catch (InvalidHudsonProjectException e) {
            logger.printError((Object)e.getLogMessage());
            logger.printStackTrace((Exception)((Object)e));
        }
        catch (Exception e) {
            logger.printError((Object)e.toString());
            logger.printStackTrace(e);
        }
        return true;
    }

    public CovComplPlotBuildAction createCovComplScatterPlotBuildAction(AbstractBuild<?, ?> build, List<MethodInfo> methods) throws IOException {
        CovComplPlotTaget cloverScatterPlotTaget = new CovComplPlotTaget(build, methods, this.analyzer, build.getTimestamp());
        CovComplPlotTaget.saveCovComplScatterPlotTarget((CovComplPlotTaget)cloverScatterPlotTaget);
        CovComplPlotBuildAction buildAction = new CovComplPlotBuildAction(build, cloverScatterPlotTaget);
        return buildAction;
    }

    public List<MethodInfo> getCovComplMethodInfoList(Analyzer analyzer, AbstractBuild<?, ?> build, boolean excludeGetterSetter, String rootDir, LoggerWrapper logger) throws InvalidHudsonProjectException {
        List methods = analyzer.getHandler().process(build, excludeGetterSetter, rootDir, logger, analyzer);
        if (methods.size() == 0) {
            throw new InvalidHudsonProjectException(InvalidHudsonProjectType.INTERNAL, new Object[]{"Method size is 0."});
        }
        return methods;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return new CovComplPlotProjectAction(project);
    }

    protected LoggerWrapper getLoggerWrapper(BuildListener listener) {
        return new LoggerWrapper(listener.getLogger(), this.verbose);
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public void setLocateTopMost(boolean locateTopMost) {
        this.locateTopMost = locateTopMost;
    }

    public boolean isLocateTopMost() {
        return this.locateTopMost;
    }
}

