/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.covcomplplot.util;

import hudson.FilePath;
import hudson.plugins.covcomplplot.util.NoXPathContentException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.springframework.core.io.ClassPathResource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class CovComplPlotUtil {
    public static DocumentFactory factory = new DocumentFactory();
    public static Map<String, String> templateCache;

    public static String getXPathNodeText(Node node, String xpathStr) throws NoXPathContentException {
        return CovComplPlotUtil.getXPathNode((Node)node, (String)xpathStr).getText();
    }

    public static List<Element> getXPathNodeList(Node node, String xpathStr) {
        List selectNodes = node.selectNodes(xpathStr);
        return selectNodes;
    }

    public static Element getXPathNode(Node node, String xpathStr) throws NoXPathContentException {
        Node selectSingleNode = node.selectSingleNode(xpathStr);
        if (selectSingleNode == null) {
            throw new NoXPathContentException(xpathStr + " is not avaliable");
        }
        return (Element)selectSingleNode;
    }

    public static Document getXmlFileDocument(InputStream stream, DocumentFactory factory) throws DocumentException {
        SAXReader reader = new SAXReader(factory);
        reader.setValidation(false);
        try {
            reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        Document doc = reader.read(stream);
        IOUtils.closeQuietly((InputStream)stream);
        return doc;
    }

    public static Document getXmlFileDocument(InputStream stream) throws DocumentException {
        return CovComplPlotUtil.getXmlFileDocument((InputStream)stream, (DocumentFactory)factory);
    }

    public static FilePath[] findFile(FilePath basePath, String pattern) {
        try {
            return basePath.list(pattern);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String getClassResourcePath(Class<?> clazz, String extension) {
        return clazz.getCanonicalName().replace(".", "/").concat(".").concat(extension);
    }

    public static int compareVersion(String v1, String v2) {
        String s1 = CovComplPlotUtil.normalisedVersion((String)v1);
        String s2 = CovComplPlotUtil.normalisedVersion((String)v2);
        return s1.compareTo(s2);
    }

    private static String normalisedVersion(String version) {
        return CovComplPlotUtil.normalisedVersion((String)version, (String)".", (int)4);
    }

    private static String normalisedVersion(String version, String sep, int maxWidth) {
        String[] split = Pattern.compile(sep, 16).split(version);
        StringBuilder sb = new StringBuilder();
        for (String s : split) {
            sb.append(String.format("%" + maxWidth + 's', s));
        }
        return sb.toString();
    }

    public static synchronized String getFileAsString(String location) {
        if (!templateCache.containsKey(location)) {
            try {
                ClassPathResource resource = new ClassPathResource(location, CovComplPlotUtil.class.getClassLoader());
                InputStream inputStream = resource.getInputStream();
                String template = IOUtils.toString((InputStream)inputStream, (String)"UTF-8");
                templateCache.put(location, template);
                IOUtils.closeQuietly((InputStream)inputStream);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        String template = (String)templateCache.get(location);
        return template;
    }

    static {
        factory.setXPathNamespaceURIs((Map)new /* Unavailable Anonymous Inner Class!! */);
        templateCache = new HashMap();
    }
}

