/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.covcomplplot.analyzer;

import hudson.model.AbstractBuild;
import hudson.plugins.covcomplplot.analyzer.AbstractMethodInfoHandler;
import hudson.plugins.covcomplplot.analyzer.Analyzer;
import hudson.plugins.covcomplplot.model.MethodInfo;
import hudson.plugins.covcomplplot.stub.InvalidHudsonProjectException;
import hudson.plugins.covcomplplot.stub.InvalidHudsonProjectType;
import hudson.plugins.covcomplplot.stub.LoggerWrapper;
import hudson.plugins.covcomplplot.util.CovComplPlotUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoberturaMethodHandler
extends AbstractMethodInfoHandler {
    Pattern branchBase = Pattern.compile("\\([0-9]*/([0-9]*)\\)");
    Pattern signaturePattern = Pattern.compile("\\((.*)\\)(.*)");
    Pattern argumentPattern = Pattern.compile("\\[*([TL][^\\;]*\\;)|([ZCBSIFJDV])");

    @Override
    public List<MethodInfo> process(AbstractBuild<?, ?> build, boolean excludeGetterSetter, String remoteDir, LoggerWrapper logger, Analyzer analyzer) throws InvalidHudsonProjectException {
        Document cobetura = super.getBuildArtifact(build, "coverage.xml", Analyzer.Cobertura);
        List<Element> elementList = null;
        Element rootElement = cobetura.getRootElement();
        try {
            elementList = CovComplPlotUtil.getXPathNodeList((Node)rootElement, "//packages/package/classes/class");
        }
        catch (Exception e) {
            throw new InvalidHudsonProjectException(InvalidHudsonProjectType.INTERNAL, "coverage.xml doesn't contain the detailed result. Please check if coverage.xml has method level infomration.");
        }
        ArrayList<MethodInfo> methods = new ArrayList<MethodInfo>();
        for (Element eachClass : elementList) {
            String path = eachClass.attributeValue("filename");
            for (Object eachMethodObject : eachClass.selectNodes("methods/method")) {
                Element eachMethodElement = (Element)eachMethodObject;
                String name = eachMethodElement.attributeValue("name");
                if (name == null || "<clinit>".equals(name) || "<init>".equals(name) || name.startsWith("__CLR")) continue;
                int complexity = 1;
                int line = 1;
                int covered = 0;
                int size = 0;
                String signature = eachMethodElement.attributeValue("signature");
                boolean first = true;
                for (Object eachLineObject : eachMethodElement.selectNodes("lines/line")) {
                    Element eachLineElement = (Element)eachLineObject;
                    if (first) {
                        String number = eachLineElement.attributeValue("number");
                        line = Math.max(1, Integer.parseInt(number) - 2);
                        first = false;
                    }
                    ++size;
                    if (!"0".equals(eachLineElement.attributeValue("hits"))) {
                        ++covered;
                    }
                    if (!"true".equals(eachLineElement.attributeValue("branch"))) continue;
                    complexity += this.getBranchCount(eachLineElement.attributeValue("condition-coverage"));
                }
                MethodInfo methodInfo = new MethodInfo(path, this.buildMethodName(name, signature), complexity, line, covered, size);
                if (!this.isMethodValid(methodInfo, excludeGetterSetter)) continue;
                methods.add(methodInfo);
            }
        }
        return methods;
    }

    private String buildMethodName(String name, String signature) {
        Matcher signatureMatcher = this.signaturePattern.matcher(signature);
        StringBuilder methodName = new StringBuilder();
        if (signatureMatcher.matches()) {
            Pattern argMatcher = this.argumentPattern;
            String returnType = signatureMatcher.group(2);
            Matcher matcher = argMatcher.matcher(returnType);
            if (matcher.matches()) {
                methodName.append(this.parseMethodArg(matcher.group()));
                methodName.append(' ');
            }
            methodName.append(name);
            String args = signatureMatcher.group(1);
            matcher = argMatcher.matcher(args);
            methodName.append('(');
            boolean first = true;
            while (matcher.find()) {
                if (!first) {
                    methodName.append(',');
                }
                methodName.append(this.parseMethodArg(matcher.group()));
                first = false;
            }
            methodName.append(')');
        } else {
            methodName.append(name);
        }
        return methodName.toString();
    }

    private String parseMethodArg(String s) {
        char c = s.charAt(0);
        switch (c) {
            case 'Z': {
                return "boolean";
            }
            case 'C': {
                return "char";
            }
            case 'B': {
                return "byte";
            }
            case 'S': {
                return "short";
            }
            case 'I': {
                return "int";
            }
            case 'F': {
                return "float";
            }
            case 'J': {
                return "";
            }
            case 'D': {
                return "double";
            }
            case 'V': {
                return "void";
            }
            case '[': {
                return this.parseMethodArg(s.substring(1)) + "[]";
            }
            case 'L': 
            case 'T': {
                int end = s.indexOf(59);
                String eachArg = s.substring(1, end).replace('/', '.');
                int index = eachArg.lastIndexOf(".") + 1;
                return eachArg.substring(Math.min(eachArg.length() - 1, index));
            }
        }
        return s;
    }

    public int getBranchCount(String text) {
        Matcher matcher = this.branchBase.matcher(text);
        if (matcher.find()) {
            return Integer.parseInt(matcher.group(1)) / 2;
        }
        return 0;
    }

    @Override
    public String getCustomJavaScript() {
        return "";
    }

    public String urlTransform(String name) {
        StringBuilder buf = new StringBuilder(name.length());
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if ('0' <= c && '9' >= c || 'A' <= c && 'Z' >= c || 'a' <= c && 'z' >= c) {
                buf.append(c);
                continue;
            }
            buf.append('_');
        }
        return buf.toString();
    }

    @Override
    public String getMethodUrlLocation(AbstractBuild<?, ?> owner, MethodInfo methodInfo) {
        String fullPath = methodInfo.getPath();
        String path = FilenameUtils.getPath((String)fullPath);
        if (StringUtils.isNotEmpty((String)path)) {
            path = path.substring(0, path.length() - 1);
        }
        path = this.urlTransform(path);
        String name = this.urlTransform(FilenameUtils.getName((String)fullPath));
        return String.format("%s/cobertura/%s/%s#%d", owner.getUrl(), path, name, methodInfo.line);
    }

    @Override
    public void checkBuild(AbstractBuild<?, ?> build) throws InvalidHudsonProjectException {
        this.checkBuildContainningBuildAction(build, "cobertura");
    }

    @Override
    public String getDescription() {
        return "Cobertura hudson plugin result is used for generating this plot.<br/> In this case, the coverage means statement coverage.";
    }
}

