/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.covcomplplot.model;

import java.text.DecimalFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodInfo
implements Comparable<MethodInfo> {
    public String sig;
    public int compl;
    public int line;
    public int cst;
    public int st;
    public String path;
    public boolean covered;
    private static DecimalFormat formatter = new DecimalFormat("#.##");

    public MethodInfo(String path, String signature, int complexity, int lineno) {
        this.path = path;
        this.sig = signature;
        this.compl = complexity;
        this.line = lineno;
    }

    public MethodInfo(String path, String signature, int complexity, int lineno, int covered, int size) {
        this.path = path;
        this.sig = signature;
        this.compl = complexity;
        this.line = lineno;
        this.cst = covered;
        this.st = size;
    }

    public float getCoverageRatio() {
        if (this.st == 0) {
            if (this.covered) {
                return 100.0f;
            }
            return 0.0f;
        }
        return (float)this.cst / (float)this.st * 100.0f;
    }

    public String getFormattedCoverageRatio() {
        float ratio = this.getCoverageRatio();
        return formatter.format(ratio);
    }

    public String getDisplaySignature() {
        if (this.sig.length() > 80) {
            return this.sig.substring(0, 77) + "...";
        }
        return this.sig;
    }

    public void increaseLine(boolean covered) {
        if (covered) {
            ++this.cst;
        }
        ++this.st;
    }

    public String toString() {
        return String.format("%s -- %s, %d, %d / %d, %d", this.path, this.sig, this.line, this.cst, this.st, (int)((float)this.cst / (float)this.st * 100.0f));
    }

    @Override
    public int compareTo(MethodInfo o) {
        int compare = o.compl - this.compl;
        if (compare == 0) {
            compare = o.st - this.st;
        }
        return compare;
    }

    public void setCompl(int compl) {
        this.compl = compl;
    }

    public int getCompl() {
        return this.compl;
    }

    public void setSig(String sig) {
        this.sig = sig;
    }

    public String getSig() {
        return this.sig;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public void increaseSizeAndCovered(int size, int covered) {
        this.st += size;
        this.cst += covered;
    }

    public void increaseComplexity(int count) {
        this.compl += count;
    }
}

