/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.cppcheck;

import com.thalesgroup.hudson.plugins.cppcheck.CppcheckBuildAction;
import com.thalesgroup.hudson.plugins.cppcheck.CppcheckChartBuilder;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.util.ChartUtil;
import java.io.IOException;
import java.io.Serializable;
import org.jfree.chart.JFreeChart;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CppcheckProjectAction
implements Action,
Serializable {
    public static final String URL_NAME = "cppcheckResult";
    public static final int CHART_WIDTH = 500;
    public static final int CHART_HEIGHT = 200;
    public AbstractProject<?, ?> project;

    public CppcheckProjectAction(AbstractProject<?, ?> project) {
        this.project = project;
    }

    public String getIconFileName() {
        return "/plugin/cppcheck/icons/cppcheck-24.png";
    }

    public String getDisplayName() {
        return "Cppcheck Results";
    }

    public String getUrlName() {
        return URL_NAME;
    }

    public void doIndex(StaplerRequest request, StaplerResponse response) throws IOException {
        AbstractBuild build = this.getLastFinishedBuild();
        if (build != null) {
            response.sendRedirect2(String.format("../%d/%s", build.getNumber(), URL_NAME));
        }
    }

    public AbstractBuild<?, ?> getLastFinishedBuild() {
        AbstractBuild lastBuild;
        for (lastBuild = (AbstractBuild)this.project.getLastBuild(); lastBuild != null && (lastBuild.isBuilding() || lastBuild.getAction(CppcheckBuildAction.class) == null); lastBuild = (AbstractBuild)lastBuild.getPreviousBuild()) {
        }
        return lastBuild;
    }

    public final boolean hasValidResults() {
        CppcheckBuildAction resultAction;
        AbstractBuild build = this.getLastFinishedBuild();
        if (build != null && (resultAction = (CppcheckBuildAction)build.getAction(CppcheckBuildAction.class)) != null) {
            return resultAction.getPreviousResult() != null;
        }
        return false;
    }

    public void doTrendMap(StaplerRequest request, StaplerResponse response) throws IOException {
        AbstractBuild lastBuild = this.getLastFinishedBuild();
        CppcheckBuildAction lastAction = (CppcheckBuildAction)lastBuild.getAction(CppcheckBuildAction.class);
        ChartUtil.generateClickableMap((StaplerRequest)request, (StaplerResponse)response, (JFreeChart)CppcheckChartBuilder.buildChart((CppcheckBuildAction)lastAction), (int)500, (int)200);
    }

    public void doTrend(StaplerRequest request, StaplerResponse response) throws IOException {
        AbstractBuild lastBuild = this.getLastFinishedBuild();
        CppcheckBuildAction lastAction = (CppcheckBuildAction)lastBuild.getAction(CppcheckBuildAction.class);
        ChartUtil.generateGraph((StaplerRequest)request, (StaplerResponse)response, (JFreeChart)CppcheckChartBuilder.buildChart((CppcheckBuildAction)lastAction), (int)500, (int)200);
    }
}

