/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.cppcheck;

import com.thalesgroup.hudson.plugins.cppcheck.CppcheckReport;
import com.thalesgroup.hudson.plugins.cppcheck.CppcheckResult;
import com.thalesgroup.hudson.plugins.cppcheck.CppcheckSummary;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import java.io.Serializable;
import org.kohsuke.stapler.StaplerProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CppcheckBuildAction
implements Action,
Serializable,
StaplerProxy {
    public static final String URL_NAME = "cppcheckResult";
    private AbstractBuild<?, ?> build;
    private CppcheckResult result;

    public CppcheckBuildAction(AbstractBuild<?, ?> build, CppcheckResult result) {
        this.build = build;
        this.result = result;
    }

    public String getIconFileName() {
        return "/plugin/cppcheck/icons/cppcheck-24.png";
    }

    public String getDisplayName() {
        return "Cppcheck Results";
    }

    public String getUrlName() {
        return URL_NAME;
    }

    public String getSummary() {
        return CppcheckSummary.createReportSummary(this.result.getReport(), this.getPreviousReport());
    }

    public String getDetails() {
        return CppcheckSummary.createReportSummaryDetails(this.result.getReport(), this.getPreviousReport());
    }

    public CppcheckResult getResult() {
        return this.result;
    }

    private CppcheckReport getPreviousReport() {
        CppcheckResult previous = this.getPreviousResult();
        if (previous == null) {
            return null;
        }
        return previous.getReport();
    }

    CppcheckResult getPreviousResult() {
        CppcheckBuildAction previousAction = this.getPreviousAction();
        CppcheckResult previousResult = null;
        if (previousAction != null) {
            previousResult = previousAction.getResult();
        }
        return previousResult;
    }

    CppcheckBuildAction getPreviousAction() {
        AbstractBuild previousBuild = (AbstractBuild)this.build.getPreviousBuild();
        if (previousBuild != null) {
            return (CppcheckBuildAction)previousBuild.getAction(CppcheckBuildAction.class);
        }
        return null;
    }

    AbstractBuild<?, ?> getBuild() {
        return this.build;
    }

    public Object getTarget() {
        return this.result;
    }
}

