/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.cppcheck;

import com.thalesgroup.hudson.plugins.cppcheck.CppcheckReport;
import com.thalesgroup.hudson.plugins.cppcheck.model.CppcheckFile;
import hudson.AbortException;
import hudson.FilePath;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CppcheckParser
implements FilePath.FileCallable<CppcheckReport> {
    private static final long serialVersionUID = 1L;
    private FilePath resultFilePath;
    private static final Logger LOGGER = Logger.getLogger(CppcheckParser.class.getName());

    public CppcheckParser() {
        this.resultFilePath = null;
    }

    public CppcheckParser(FilePath resultFilePath) {
        this.resultFilePath = resultFilePath;
    }

    public CppcheckReport invoke(File workspace, VirtualChannel channel) throws IOException {
        CppcheckReport cppCheckReport = new CppcheckReport();
        Document document = null;
        try {
            SAXBuilder sxb = new SAXBuilder();
            document = sxb.build((Reader)new InputStreamReader((InputStream)new FileInputStream(new File(this.resultFilePath.toURI())), "UTF-8"));
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Parsing file error :" + e.toString());
            throw new AbortException("Parsing file error");
        }
        Element results = document.getRootElement();
        List list = results.getChildren();
        ArrayList<CppcheckFile> errors = new ArrayList<CppcheckFile>();
        for (int i = 0; i < list.size(); ++i) {
            Element elt = (Element)list.get(i);
            CppcheckFile cppcheckFile = new CppcheckFile();
            cppcheckFile.setFilename(elt.getAttributeValue("file"));
            String lineAtr = null;
            lineAtr = elt.getAttributeValue("line");
            if (lineAtr != null) {
                cppcheckFile.setLineNumber(Integer.parseInt(lineAtr));
            }
            cppcheckFile.setCppCheckId(elt.getAttributeValue("id"));
            cppcheckFile.setSeverity(elt.getAttributeValue("severity"));
            cppcheckFile.setMessage(elt.getAttributeValue("msg"));
            errors.add(cppcheckFile);
        }
        cppCheckReport.setErrors(errors);
        return cppCheckReport;
    }

    public FilePath getResultFilePath() {
        return this.resultFilePath;
    }

    public void setResultFilePath(FilePath resultFilePath) {
        this.resultFilePath = resultFilePath;
    }
}

