/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.cppcheck;

import com.thalesgroup.hudson.plugins.cppcheck.CppcheckBuildAction;
import com.thalesgroup.hudson.plugins.cppcheck.CppcheckDescriptor;
import com.thalesgroup.hudson.plugins.cppcheck.CppcheckParser;
import com.thalesgroup.hudson.plugins.cppcheck.CppcheckProjectAction;
import com.thalesgroup.hudson.plugins.cppcheck.CppcheckReport;
import com.thalesgroup.hudson.plugins.cppcheck.CppcheckResult;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.tasks.Publisher;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CppcheckPublisher
extends Publisher
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final CppcheckDescriptor DESCRIPTOR = new CppcheckDescriptor();
    private final String metricFilePath;

    public Descriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    @DataBoundConstructor
    public CppcheckPublisher(String metricFilePath) {
        this.metricFilePath = metricFilePath;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return new CppcheckProjectAction(project);
    }

    protected boolean canContinue(Result result) {
        return result != Result.ABORTED && result != Result.FAILURE;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        if (this.canContinue(build.getResult())) {
            CppcheckReport report;
            listener.getLogger().println("Parsing cppcheck results");
            FilePath workspace = build.getProject().getWorkspace();
            PrintStream logger = listener.getLogger();
            CppcheckParser parser = new CppcheckParser(new FilePath(((AbstractProject)build.getParent()).getWorkspace(), this.metricFilePath));
            try {
                report = (CppcheckReport)workspace.act((FilePath.FileCallable)parser);
            }
            catch (IOException ioe) {
                ioe.printStackTrace(logger);
                build.setResult(Result.FAILURE);
                return false;
            }
            catch (InterruptedException ie) {
                ie.printStackTrace(logger);
                build.setResult(Result.FAILURE);
                return false;
            }
            CppcheckResult result = new CppcheckResult(report, build);
            CppcheckBuildAction buildAction = new CppcheckBuildAction(build, result);
            build.addAction((Action)buildAction);
            listener.getLogger().println("End Processing cppcheck results");
        }
        return true;
    }

    public String getMetricFilePath() {
        return this.metricFilePath;
    }
}

