/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.cppcheck;

import com.thalesgroup.hudson.plugins.cppcheck.CppcheckBuildAction;
import com.thalesgroup.hudson.plugins.cppcheck.CppcheckParserResult;
import com.thalesgroup.hudson.plugins.cppcheck.CppcheckProjectAction;
import com.thalesgroup.hudson.plugins.cppcheck.CppcheckReport;
import com.thalesgroup.hudson.plugins.cppcheck.CppcheckResult;
import com.thalesgroup.hudson.plugins.cppcheck.config.CppcheckConfig;
import com.thalesgroup.hudson.plugins.cppcheck.model.CppcheckSourceContainer;
import com.thalesgroup.hudson.plugins.cppcheck.model.CppcheckWorkspaceFile;
import com.thalesgroup.hudson.plugins.cppcheck.util.CppcheckBuildResultEvaluator;
import com.thalesgroup.hudson.plugins.cppcheck.util.CppcheckLogger;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.matrix.MatrixProject;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.FreeStyleProject;
import hudson.model.Result;
import hudson.remoting.VirtualChannel;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CppcheckPublisher
extends Recorder {
    private CppcheckConfig cppcheckConfig;
    @Extension
    public static final CppcheckDescriptor DESCRIPTOR = new CppcheckDescriptor();

    public CppcheckDescriptor getDescriptor() {
        return DESCRIPTOR;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return new CppcheckProjectAction(project);
    }

    protected boolean canContinue(Result result) {
        return result != Result.ABORTED && result != Result.FAILURE;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        if (this.canContinue(build.getResult())) {
            CppcheckReport cppcheckReport;
            CppcheckLogger.log(listener, "Starting the cppcheck analysis.");
            CppcheckParserResult parser = new CppcheckParserResult(listener, this.cppcheckConfig.getCppcheckReportPattern());
            try {
                cppcheckReport = (CppcheckReport)build.getWorkspace().act((FilePath.FileCallable)parser);
            }
            catch (Exception e) {
                CppcheckLogger.log(listener, "Error on cppcheck analysis: " + e);
                build.setResult(Result.FAILURE);
                return false;
            }
            if (cppcheckReport == null) {
                build.setResult(Result.FAILURE);
                return false;
            }
            CppcheckSourceContainer cppcheckSourceContainer = new CppcheckSourceContainer(listener, build.getWorkspace(), cppcheckReport.getEverySeverities());
            CppcheckResult result = new CppcheckResult(cppcheckReport, cppcheckSourceContainer, build);
            Result buildResult = new CppcheckBuildResultEvaluator().evaluateBuildResult(listener, result.getNumberErrorsAccordingConfiguration(this.cppcheckConfig, false), result.getNumberErrorsAccordingConfiguration(this.cppcheckConfig, true), this.cppcheckConfig);
            if (buildResult != Result.SUCCESS) {
                build.setResult(buildResult);
            }
            CppcheckBuildAction buildAction = new CppcheckBuildAction(build, result, this.cppcheckConfig);
            build.addAction((Action)buildAction);
            if (build.getWorkspace().isRemote()) {
                this.copyFilesFromSlaveToMaster(build.getRootDir(), launcher.getChannel(), cppcheckSourceContainer.getInternalMap().values());
            }
            CppcheckLogger.log(listener, "End of the cppcheck analysis.");
        }
        return true;
    }

    private void copyFilesFromSlaveToMaster(File rootDir, VirtualChannel channel, Collection<CppcheckWorkspaceFile> sourcesFiles) throws IOException, InterruptedException {
        File directory = new File(rootDir, "workspace-files");
        if (!directory.exists()) {
            if (!directory.delete()) {
                // empty if block
            }
            if (!directory.mkdir()) {
                throw new IOException("Can't create directory for remote source files: " + directory.getAbsolutePath());
            }
        }
        for (CppcheckWorkspaceFile file : sourcesFiles) {
            File masterFile;
            if (file.isSourceIgnored() || (masterFile = new File(directory, file.getTempName())).exists()) continue;
            FileOutputStream outputStream = new FileOutputStream(masterFile);
            new FilePath(channel, file.getFileName()).copyTo((OutputStream)outputStream);
        }
    }

    public CppcheckConfig getCppcheckConfig() {
        return this.cppcheckConfig;
    }

    public void setCppcheckConfig(CppcheckConfig cppcheckConfig) {
        this.cppcheckConfig = cppcheckConfig;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class CppcheckDescriptor
    extends BuildStepDescriptor<Publisher> {
        public CppcheckDescriptor() {
            super(CppcheckPublisher.class);
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return FreeStyleProject.class.isAssignableFrom(jobType) || MatrixProject.class.isAssignableFrom(jobType);
        }

        public String getDisplayName() {
            return "Publish Cppcheck results";
        }

        public final String getHelpFile() {
            return this.getPluginRoot() + "help.html";
        }

        public String getPluginRoot() {
            return "/plugin/cppcheck/";
        }

        public CppcheckConfig getConfig() {
            return new CppcheckConfig();
        }

        public Publisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            CppcheckPublisher pub = new CppcheckPublisher();
            CppcheckConfig cppcheckConfig = (CppcheckConfig)req.bindJSON(CppcheckConfig.class, formData);
            pub.setCppcheckConfig(cppcheckConfig);
            return pub;
        }
    }
}

