/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.cppcheck.util;

import com.thalesgroup.hudson.plugins.cppcheck.CppcheckResult;
import com.thalesgroup.hudson.plugins.cppcheck.config.CppcheckConfig;

public class CppcheckUtil {
    public static int getNumberErrors(CppcheckConfig cppecheckConfig, CppcheckResult result, boolean checkNewError) {
        int nbErrors = 0;
        int nbPreviousError = 0;
        CppcheckResult previousResult = result.getPreviousResult();
        if (cppecheckConfig.getConfigSeverityEvaluation().isSeverityPossibleError()) {
            nbErrors = result.getReport().getPossibleErrorSeverities().size();
            if (previousResult != null) {
                nbPreviousError = previousResult.getReport().getPossibleErrorSeverities().size();
            }
        }
        if (cppecheckConfig.getConfigSeverityEvaluation().isSeverityStyle()) {
            nbErrors += result.getReport().getStyleSeverities().size();
            if (previousResult != null) {
                nbPreviousError += previousResult.getReport().getStyleSeverities().size();
            }
        }
        if (cppecheckConfig.getConfigSeverityEvaluation().isSeverityPossibleStyle()) {
            nbErrors += result.getReport().getPossibleStyleSeverities().size();
            if (previousResult != null) {
                nbPreviousError += previousResult.getReport().getPossibleStyleSeverities().size();
            }
        }
        if (cppecheckConfig.getConfigSeverityEvaluation().isSeverityError()) {
            nbErrors += result.getReport().getErrorSeverities().size();
            if (previousResult != null) {
                nbPreviousError += previousResult.getReport().getErrorSeverities().size();
            }
        }
        if (checkNewError) {
            if (previousResult != null) {
                return nbErrors - nbPreviousError;
            }
            return 0;
        }
        return nbErrors;
    }
}

