/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.cppcheck.util;

import com.thalesgroup.hudson.plugins.cppcheck.CppcheckMetricUtil;
import com.thalesgroup.hudson.plugins.cppcheck.config.CppcheckConfig;
import com.thalesgroup.hudson.plugins.cppcheck.util.CppcheckLogger;
import hudson.model.BuildListener;
import hudson.model.Result;

public class CppcheckBuildResultEvaluator {
    private boolean isErrorCountExceeded(int errorCount, String errorThreshold) {
        if (errorCount > 0 && CppcheckMetricUtil.isValid((String)errorThreshold)) {
            return errorCount > CppcheckMetricUtil.convert((String)errorThreshold);
        }
        return false;
    }

    public Result evaluateBuildResult(BuildListener listener, int errorsCount, int newErrorsCount, CppcheckConfig cppcheckConfig) {
        if (this.isErrorCountExceeded(errorsCount, cppcheckConfig.getConfigSeverityEvaluation().getFailureThreshold())) {
            CppcheckLogger.log((BuildListener)listener, (String)("Setting build status to FAILURE since total number of errors (" + CppcheckMetricUtil.getMessageSelectedSeverties((CppcheckConfig)cppcheckConfig) + ") exceeds the threshold value ;" + cppcheckConfig.getConfigSeverityEvaluation().getFailureThreshold() + "'."));
            return Result.FAILURE;
        }
        if (this.isErrorCountExceeded(newErrorsCount, cppcheckConfig.getConfigSeverityEvaluation().getNewFailureThreshold())) {
            CppcheckLogger.log((BuildListener)listener, (String)("Setting build status to FAILURE since total number of new errors (" + CppcheckMetricUtil.getMessageSelectedSeverties((CppcheckConfig)cppcheckConfig) + ") exceeds the threshold value '" + cppcheckConfig.getConfigSeverityEvaluation().getNewFailureThreshold() + "'."));
            return Result.FAILURE;
        }
        if (this.isErrorCountExceeded(errorsCount, cppcheckConfig.getConfigSeverityEvaluation().getThreshold())) {
            CppcheckLogger.log((BuildListener)listener, (String)("Setting build status to UNSTABLE since total number of errors (" + CppcheckMetricUtil.getMessageSelectedSeverties((CppcheckConfig)cppcheckConfig) + ") exceeds the threshold value '" + cppcheckConfig.getConfigSeverityEvaluation().getThreshold() + "'."));
            return Result.UNSTABLE;
        }
        if (this.isErrorCountExceeded(newErrorsCount, cppcheckConfig.getConfigSeverityEvaluation().getNewThreshold())) {
            CppcheckLogger.log((BuildListener)listener, (String)("Setting build status to UNSTABLE since total number of new errors (" + CppcheckMetricUtil.getMessageSelectedSeverties((CppcheckConfig)cppcheckConfig) + ") exceeds the threshold value '" + cppcheckConfig.getConfigSeverityEvaluation().getNewThreshold() + "'."));
            return Result.UNSTABLE;
        }
        CppcheckLogger.log((BuildListener)listener, (String)"Not changing build status, since no threshold has been exceeded");
        return Result.SUCCESS;
    }
}

