/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.cppcheck;

import com.thalesgroup.hudson.plugins.cppcheck.CppcheckReport;
import com.thalesgroup.hudson.plugins.cppcheck.model.CppcheckFile;
import hudson.AbortException;
import hudson.FilePath;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CppcheckParser
implements FilePath.FileCallable<CppcheckReport> {
    private static final long serialVersionUID = 1L;
    private FilePath resultFilePath;
    private static final Logger LOGGER = Logger.getLogger(CppcheckParser.class.getName());

    public CppcheckParser(FilePath resultFilePath) {
        if (resultFilePath == null) {
            throw new IllegalArgumentException("The cppcheck result file is mandatory.");
        }
        this.resultFilePath = resultFilePath;
    }

    private CppcheckReport parse(File file) throws IOException, JDOMException {
        CppcheckReport cppCheckReport = new CppcheckReport();
        Document document = null;
        SAXBuilder sxb = new SAXBuilder();
        FileInputStream fis = new FileInputStream(file);
        InputStreamReader isr = new InputStreamReader(fis);
        document = sxb.build((Reader)isr);
        fis.close();
        isr.close();
        Element results = document.getRootElement();
        List list = results.getChildren();
        ArrayList<CppcheckFile> everyErrors = new ArrayList<CppcheckFile>();
        ArrayList<CppcheckFile> allErrors = new ArrayList<CppcheckFile>();
        ArrayList<CppcheckFile> styleErrors = new ArrayList<CppcheckFile>();
        ArrayList<CppcheckFile> allStyleErrors = new ArrayList<CppcheckFile>();
        ArrayList<CppcheckFile> errorErrors = new ArrayList<CppcheckFile>();
        ArrayList<CppcheckFile> noCategoryErrors = new ArrayList<CppcheckFile>();
        HashMap<Integer, CppcheckFile> agregateMap = new HashMap<Integer, CppcheckFile>();
        for (int i = 0; i < list.size(); ++i) {
            Element elt = (Element)list.get(i);
            CppcheckFile cppcheckFile = new CppcheckFile();
            cppcheckFile.setKey(Integer.valueOf(i + 1));
            cppcheckFile.setFileName(elt.getAttributeValue("file"));
            String lineAtr = null;
            lineAtr = elt.getAttributeValue("line");
            if (lineAtr != null) {
                cppcheckFile.setLineNumber(Integer.parseInt(lineAtr));
            }
            cppcheckFile.setCppCheckId(elt.getAttributeValue("id"));
            cppcheckFile.setSeverity(elt.getAttributeValue("severity"));
            cppcheckFile.setMessage(elt.getAttributeValue("msg"));
            if ("all".equals(cppcheckFile.getSeverity())) {
                allErrors.add(cppcheckFile);
            } else if ("style".equals(cppcheckFile.getSeverity())) {
                styleErrors.add(cppcheckFile);
            } else if ("all style".equals(cppcheckFile.getSeverity())) {
                allStyleErrors.add(cppcheckFile);
            } else if ("error".equals(cppcheckFile.getSeverity())) {
                errorErrors.add(cppcheckFile);
            } else {
                noCategoryErrors.add(cppcheckFile);
            }
            everyErrors.add(cppcheckFile);
            agregateMap.put(cppcheckFile.getKey(), cppcheckFile);
        }
        cppCheckReport.setEveryErrors(everyErrors);
        cppCheckReport.setAllErrors(allErrors);
        cppCheckReport.setStyleErrors(styleErrors);
        cppCheckReport.setAllStyleErrors(allStyleErrors);
        cppCheckReport.setErrorErrors(errorErrors);
        cppCheckReport.setNoCategoryErrors(noCategoryErrors);
        cppCheckReport.setInternalMap(agregateMap);
        return cppCheckReport;
    }

    public CppcheckReport invoke(File workspace, VirtualChannel channel) throws IOException {
        try {
            return this.parse(new File(this.resultFilePath.toURI()));
        }
        catch (FileNotFoundException fne) {
            LOGGER.log(Level.SEVERE, "Parsing file error :" + fne.toString());
            throw new AbortException(String.format("The %s file is not found", this.resultFilePath));
        }
        catch (JDOMException jdoe) {
            LOGGER.log(Level.SEVERE, "Parsing file error :" + jdoe.toString());
            throw new AbortException("Parsing file error");
        }
        catch (InterruptedException ie) {
            LOGGER.log(Level.SEVERE, "Parsing file error :" + ie.toString());
            throw new AbortException("Parsing file error");
        }
    }

    public FilePath getResultFilePath() {
        return this.resultFilePath;
    }

    public void setResultFilePath(FilePath resultFilePath) {
        this.resultFilePath = resultFilePath;
    }
}

