/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.cppcheck;

import com.thalesgroup.hudson.plugins.cppcheck.CppcheckBuildAction;
import com.thalesgroup.hudson.plugins.cppcheck.CppcheckHealthReportThresholds;
import com.thalesgroup.hudson.plugins.cppcheck.CppcheckParser;
import com.thalesgroup.hudson.plugins.cppcheck.CppcheckProjectAction;
import com.thalesgroup.hudson.plugins.cppcheck.CppcheckPublisher;
import com.thalesgroup.hudson.plugins.cppcheck.CppcheckReport;
import com.thalesgroup.hudson.plugins.cppcheck.CppcheckResult;
import com.thalesgroup.hudson.plugins.cppcheck.util.CppcheckBuildResultEvaluator;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.tasks.Publisher;
import java.io.IOException;
import java.io.PrintStream;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CppcheckPublisher
extends Publisher {
    private final String metricFilePath;
    private final String threshold;
    private final String newThreshold;
    private final String failureThreshold;
    private final String newFailureThreshold;
    private final String healthy;
    private final String unHealthy;
    private final String thresholdLimit;
    public static final CppcheckDescriptor DESCRIPTOR = new CppcheckDescriptor();

    public CppcheckDescriptor getDescriptor() {
        return DESCRIPTOR;
    }

    @DataBoundConstructor
    public CppcheckPublisher(String metricFilePath, String threshold, String newThreshold, String failureThreshold, String newFailureThreshold, String healthy, String unHealthy, String thresholdLimit) {
        this.metricFilePath = metricFilePath;
        this.threshold = threshold;
        this.newFailureThreshold = newFailureThreshold;
        this.newThreshold = newThreshold;
        this.failureThreshold = failureThreshold;
        this.healthy = healthy;
        this.unHealthy = unHealthy;
        this.thresholdLimit = thresholdLimit;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return new CppcheckProjectAction(project);
    }

    protected boolean canContinue(Result result) {
        return result != Result.ABORTED && result != Result.FAILURE;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        if (this.canContinue(build.getResult())) {
            CppcheckReport report;
            listener.getLogger().println("Parsing cppcheck results");
            FilePath workspace = build.getProject().getWorkspace();
            PrintStream logger = listener.getLogger();
            CppcheckParser parser = new CppcheckParser(new FilePath(((AbstractProject)build.getParent()).getWorkspace(), this.metricFilePath));
            try {
                report = (CppcheckReport)workspace.act((FilePath.FileCallable)parser);
            }
            catch (IOException ioe) {
                ioe.printStackTrace(logger);
                build.setResult(Result.FAILURE);
                return false;
            }
            catch (InterruptedException ie) {
                ie.printStackTrace(logger);
                build.setResult(Result.FAILURE);
                return false;
            }
            CppcheckHealthReportThresholds cppcheckHealthReportThresholds = new CppcheckHealthReportThresholds(this.threshold, this.newThreshold, this.failureThreshold, this.newFailureThreshold, this.healthy, this.unHealthy, this.thresholdLimit);
            CppcheckResult result = new CppcheckResult(report, build);
            CppcheckBuildAction buildAction = new CppcheckBuildAction(build, result, cppcheckHealthReportThresholds);
            build.addAction((Action)buildAction);
            Result buildResult = new CppcheckBuildResultEvaluator().evaluateBuildResult(logger, buildAction.getNumberErrors(this.thresholdLimit, false), buildAction.getNumberErrors(this.thresholdLimit, true), cppcheckHealthReportThresholds);
            if (buildResult != Result.SUCCESS) {
                build.setResult(buildResult);
            }
            listener.getLogger().println("End Processing cppcheck results");
        }
        return true;
    }

    public String getMetricFilePath() {
        return this.metricFilePath;
    }

    public String getThreshold() {
        return this.threshold;
    }

    public String getNewThreshold() {
        return this.newThreshold;
    }

    public String getFailureThreshold() {
        return this.failureThreshold;
    }

    public String getNewFailureThreshold() {
        return this.newFailureThreshold;
    }

    public String getHealthy() {
        return this.healthy;
    }

    public String getUnHealthy() {
        return this.unHealthy;
    }

    public String getThresholdLimit() {
        return this.thresholdLimit;
    }
}

