/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.cppcheck;

import com.thalesgroup.hudson.plugins.cppcheck.model.CppcheckFile;
import de.java2html.converter.JavaSource2HTMLConverter;
import de.java2html.javasource.JavaSource;
import de.java2html.javasource.JavaSourceParser;
import de.java2html.options.JavaSourceConversionOptions;
import hudson.model.AbstractBuild;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang.StringEscapeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CppcheckSource
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final int SOURCE_GENERATOR_OFFSET = 13;
    private static final String MESSAGE_COLOR = "#FCAF3E";
    private final AbstractBuild<?, ?> owner;
    private final CppcheckFile cppcheckFile;
    private String sourceCode = "";

    public CppcheckSource(AbstractBuild<?, ?> owner, CppcheckFile cppcheckFile) {
        this.owner = owner;
        this.cppcheckFile = cppcheckFile;
        this.initializeContent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeContent() {
        FileInputStream is = null;
        try {
            File f = new File(this.cppcheckFile.getFileName());
            is = f.exists() ? new FileInputStream(f) : new FileInputStream(new File(this.owner.getProject().getModuleRoot() + "/" + this.cppcheckFile.getFileName()));
            this.splitSourceFile(this.highlightSource((InputStream)is));
        }
        catch (IOException exception) {
            try {
                this.sourceCode = "Can't read file: " + exception.getLocalizedMessage();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)is);
        }
        IOUtils.closeQuietly((InputStream)is);
    }

    public final void splitSourceFile(String sourceFile) {
        int lineNumber;
        StringBuilder output = new StringBuilder(sourceFile.length());
        LineIterator lineIterator = IOUtils.lineIterator((Reader)new StringReader(sourceFile));
        for (lineNumber = 1; lineNumber < 13; ++lineNumber) {
            this.copyLine(output, lineIterator);
        }
        for (lineNumber = 1; lineNumber < this.cppcheckFile.getLineNumber(); ++lineNumber) {
            this.copyLine(output, lineIterator);
        }
        output.append("</code>\n");
        output.append("</td></tr>\n");
        output.append("<tr><td bgcolor=\"");
        this.appendRangeColor(output);
        output.append("\">\n");
        output.append("<div tooltip=\"");
        this.outputEscaped(output, this.cppcheckFile.getCppCheckId() + ":" + this.cppcheckFile.getMessage());
        output.append("\" nodismiss=\"\">\n");
        output.append("<code><b>\n");
        this.copyLine(output, lineIterator);
        ++lineNumber;
        output.append("</b></code>\n");
        output.append("</div>\n");
        output.append("</td></tr>\n");
        output.append("<tr><td>\n");
        output.append("<code>\n");
        while (lineIterator.hasNext()) {
            this.copyLine(output, lineIterator);
        }
        output.append("</code>\n");
        output.append("</td></tr>\n");
        this.sourceCode = output.toString();
    }

    private void outputEscaped(StringBuilder output, String message) {
        output.append(StringEscapeUtils.escapeHtml((String)message));
    }

    private void appendRangeColor(StringBuilder output) {
        output.append(MESSAGE_COLOR);
    }

    private void copyLine(StringBuilder output, LineIterator lineIterator) {
        output.append(lineIterator.nextLine());
        output.append("\n");
    }

    public final String highlightSource(InputStream file) throws IOException {
        JavaSource source = new JavaSourceParser().parse((Reader)new InputStreamReader(file));
        JavaSource2HTMLConverter converter = new JavaSource2HTMLConverter();
        StringWriter writer = new StringWriter();
        JavaSourceConversionOptions options = JavaSourceConversionOptions.getDefault();
        options.setShowLineNumbers(true);
        options.setAddLineAnchors(true);
        converter.convert(source, options, (Writer)writer);
        return writer.toString();
    }

    public String getSourceCode() {
        return this.sourceCode;
    }

    public CppcheckFile getCppcheckFile() {
        return this.cppcheckFile;
    }
}

