/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.cppcheck.util;

import com.thalesgroup.hudson.plugins.cppcheck.CppcheckHealthReportThresholds;
import hudson.model.Result;
import java.io.PrintStream;

public class CppcheckBuildResultEvaluator {
    private boolean isErrorCountExceeded(int errorCount, String errorThreshold) {
        if (errorCount > 0 && CppcheckHealthReportThresholds.isValid((String)errorThreshold)) {
            return errorCount > CppcheckHealthReportThresholds.convert((String)errorThreshold);
        }
        return false;
    }

    public Result evaluateBuildResult(PrintStream logger, int errorsCount, int newErrorsCount, CppcheckHealthReportThresholds cppcheckHealthReportThresholds) {
        if (this.isErrorCountExceeded(errorsCount, cppcheckHealthReportThresholds.getFailureThreshold())) {
            logger.println("Setting build status to FAILURE since total number of errors exceeds the threshold " + cppcheckHealthReportThresholds.getFailureThreshold());
            return Result.FAILURE;
        }
        if (this.isErrorCountExceeded(newErrorsCount, cppcheckHealthReportThresholds.getNewFailureThreshold())) {
            logger.println("Setting build status to FAILURE since total number of new errors exceeds the threshold " + cppcheckHealthReportThresholds.getNewFailureThreshold());
            return Result.FAILURE;
        }
        if (this.isErrorCountExceeded(errorsCount, cppcheckHealthReportThresholds.getThreshold())) {
            logger.println("Setting build status to UNSTABLE since total number of errors exceeds the threshold " + cppcheckHealthReportThresholds.getThreshold());
            return Result.UNSTABLE;
        }
        if (this.isErrorCountExceeded(newErrorsCount, cppcheckHealthReportThresholds.getNewThreshold())) {
            logger.println("Setting build status to UNSTABLE since total number of new errors exceeds the threshold " + cppcheckHealthReportThresholds.getNewThreshold());
            return Result.UNSTABLE;
        }
        logger.println("Not changing build status, since no threshold has been exceeded");
        return Result.SUCCESS;
    }
}

