/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.cppcheck;

import com.thalesgroup.hudson.plugins.cppcheck.CppcheckReport;
import com.thalesgroup.hudson.plugins.cppcheck.parser.CppcheckParser;
import com.thalesgroup.hudson.plugins.cppcheck.util.Messages;
import hudson.FilePath;
import hudson.Util;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CppcheckParserResult
implements FilePath.FileCallable<CppcheckReport> {
    private static final long serialVersionUID = 1L;
    private final PrintStream logger;
    private final String cppcheckReportPattern;
    public static final String DELAULT_REPORT_MAVEN = "**/cppcheck-result.xml";

    public CppcheckParserResult(PrintStream logger, String cppcheckReportPattern) {
        if (cppcheckReportPattern == null) {
            cppcheckReportPattern = DELAULT_REPORT_MAVEN;
        }
        if (cppcheckReportPattern.trim().length() == 0) {
            cppcheckReportPattern = DELAULT_REPORT_MAVEN;
        }
        this.logger = logger;
        this.cppcheckReportPattern = cppcheckReportPattern;
    }

    public CppcheckReport invoke(File moduleRoot, VirtualChannel channel) throws IOException {
        CppcheckReport cppcheckReportResult = new CppcheckReport();
        try {
            String[] cppcheckFiles = this.findCppcheckReports(moduleRoot);
            if (cppcheckFiles.length == 0) {
                throw new IllegalArgumentException("No cppcheck test report file(s) were found with the pattern '" + this.cppcheckReportPattern + "'.");
            }
            Messages.log(this.logger, "Processing " + cppcheckFiles.length + " files with the pattern '" + this.cppcheckReportPattern + "'.");
            for (String cppcheckFile : cppcheckFiles) {
                CppcheckReport cppcheckReport = new CppcheckParser().parse(new File(moduleRoot, cppcheckFile));
                this.mergeReport(cppcheckReportResult, cppcheckReport);
            }
        }
        catch (Exception e) {
            Messages.log(this.logger, "Parsing has been canceled. " + e.getMessage());
            return null;
        }
        return cppcheckReportResult;
    }

    private void mergeReport(CppcheckReport cppcheckReportResult, CppcheckReport cppcheckReport) {
        cppcheckReportResult.getAllErrors().addAll(cppcheckReport.getAllErrors());
        cppcheckReportResult.getAllStyleErrors().addAll(cppcheckReport.getAllStyleErrors());
        cppcheckReportResult.getErrorErrors().addAll(cppcheckReport.getErrorErrors());
        cppcheckReportResult.getEveryErrors().addAll(cppcheckReport.getEveryErrors());
        cppcheckReportResult.getInternalMap().putAll(cppcheckReport.getInternalMap());
        cppcheckReportResult.getNoCategoryErrors().addAll(cppcheckReport.getNoCategoryErrors());
        cppcheckReportResult.getStyleErrors().addAll(cppcheckReport.getStyleErrors());
    }

    private String[] findCppcheckReports(File parentPath) {
        FileSet fs = Util.createFileSet((File)parentPath, (String)this.cppcheckReportPattern);
        DirectoryScanner ds = fs.getDirectoryScanner();
        String[] cppcheckFiles = ds.getIncludedFiles();
        return cppcheckFiles;
    }

    public String getCppcheckReportPattern() {
        return this.cppcheckReportPattern;
    }
}

