/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.cppcheck;

import com.thalesgroup.hudson.plugins.cppcheck.CppcheckHealthReportThresholds;
import com.thalesgroup.hudson.plugins.cppcheck.CppcheckResult;
import com.thalesgroup.hudson.plugins.cppcheck.util.CppcheckBuildHealthEvaluator;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.HealthReport;
import hudson.model.HealthReportingAction;
import java.io.Serializable;
import org.kohsuke.stapler.StaplerProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CppcheckBuildAction
implements Action,
Serializable,
StaplerProxy,
HealthReportingAction {
    public static final String URL_NAME = "cppcheckResult";
    private AbstractBuild<?, ?> build;
    private CppcheckResult result;
    private CppcheckHealthReportThresholds cppcheckHealthReportThresholds;

    public CppcheckBuildAction(AbstractBuild<?, ?> build, CppcheckResult result, CppcheckHealthReportThresholds cppcheckHealthReportThresholds) {
        this.build = build;
        this.result = result;
        this.cppcheckHealthReportThresholds = cppcheckHealthReportThresholds;
    }

    public String getIconFileName() {
        return "/plugin/cppcheck/icons/cppcheck-24.png";
    }

    public String getDisplayName() {
        return "Cppcheck Result";
    }

    public String getUrlName() {
        return URL_NAME;
    }

    public CppcheckResult getResult() {
        return this.result;
    }

    AbstractBuild<?, ?> getBuild() {
        return this.build;
    }

    public Object getTarget() {
        return this.result;
    }

    public HealthReport getBuildHealth() {
        return new CppcheckBuildHealthEvaluator().evaluatBuildHealth(this.cppcheckHealthReportThresholds, this.getNumberErrors(this.cppcheckHealthReportThresholds.getThresholdLimit(), false));
    }

    public int getNumberErrors(String thresholdLimit, boolean newError) {
        int nbErrors = 0;
        int nbPreviousError = 0;
        CppcheckResult previousResult = this.result.getPreviousResult();
        if ("all".equals(thresholdLimit)) {
            nbErrors = this.getResult().getReport().getAllErrors().size();
            if (previousResult != null) {
                nbPreviousError = previousResult.getReport().getAllErrors().size();
            }
        } else if ("style".equals(thresholdLimit)) {
            nbErrors = this.getResult().getReport().getStyleErrors().size();
            if (previousResult != null) {
                nbPreviousError = previousResult.getReport().getStyleErrors().size();
            }
        } else if ("all style".equals(thresholdLimit)) {
            nbErrors = this.getResult().getReport().getAllStyleErrors().size();
            if (previousResult != null) {
                nbPreviousError = previousResult.getReport().getAllStyleErrors().size();
            }
        } else if ("error".equals(thresholdLimit)) {
            nbErrors = this.getResult().getReport().getErrorErrors().size();
            if (previousResult != null) {
                nbPreviousError = previousResult.getReport().getErrorErrors().size();
            }
        } else {
            nbErrors = this.getResult().getReport().getEveryErrors().size();
            if (previousResult != null) {
                nbPreviousError = previousResult.getReport().getEveryErrors().size();
            }
        }
        if (newError) {
            if (previousResult != null) {
                return nbErrors - nbPreviousError;
            }
            return 0;
        }
        return nbErrors;
    }
}

