/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.cppcheck;

import com.thalesgroup.hudson.plugins.cppcheck.CppcheckBuildAction;
import com.thalesgroup.hudson.plugins.cppcheck.CppcheckHealthReportThresholds;
import com.thalesgroup.hudson.plugins.cppcheck.CppcheckParserResult;
import com.thalesgroup.hudson.plugins.cppcheck.CppcheckProjectAction;
import com.thalesgroup.hudson.plugins.cppcheck.CppcheckReport;
import com.thalesgroup.hudson.plugins.cppcheck.CppcheckResult;
import com.thalesgroup.hudson.plugins.cppcheck.util.CppcheckBuildResultEvaluator;
import com.thalesgroup.hudson.plugins.cppcheck.util.Messages;
import hudson.FilePath;
import hudson.Launcher;
import hudson.matrix.MatrixProject;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.FreeStyleProject;
import hudson.model.Result;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Publisher;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CppcheckPublisher
extends Publisher {
    private final String cppcheckReportPattern;
    private final String threshold;
    private final String newThreshold;
    private final String failureThreshold;
    private final String newFailureThreshold;
    private final String healthy;
    private final String unHealthy;
    private final String thresholdLimit;
    public static final CppcheckDescriptor DESCRIPTOR = new CppcheckDescriptor();

    public CppcheckDescriptor getDescriptor() {
        return DESCRIPTOR;
    }

    @DataBoundConstructor
    public CppcheckPublisher(String cppcheckReportPattern, String threshold, String newThreshold, String failureThreshold, String newFailureThreshold, String healthy, String unHealthy, String thresholdLimit) {
        this.cppcheckReportPattern = cppcheckReportPattern;
        this.threshold = threshold;
        this.newFailureThreshold = newFailureThreshold;
        this.newThreshold = newThreshold;
        this.failureThreshold = failureThreshold;
        this.healthy = healthy;
        this.unHealthy = unHealthy;
        this.thresholdLimit = thresholdLimit;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return new CppcheckProjectAction(project);
    }

    protected boolean canContinue(Result result) {
        return result != Result.ABORTED && result != Result.FAILURE;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        if (this.canContinue(build.getResult())) {
            Messages.log(listener, "Starting the cppcheck analysis.");
            FilePath[] moduleRoots = build.getProject().getModuleRoots();
            boolean multipleModuleRoots = moduleRoots != null && moduleRoots.length > 1;
            FilePath moduleRoot = multipleModuleRoots ? build.getProject().getWorkspace() : build.getProject().getModuleRoot();
            CppcheckParserResult parser = new CppcheckParserResult(listener, this.getCppcheckReportPattern());
            CppcheckReport cppcheckReport = null;
            try {
                cppcheckReport = (CppcheckReport)moduleRoot.act((FilePath.FileCallable)parser);
            }
            catch (Exception e) {
                Messages.log(listener, "Error on cppcheck analysis: " + e);
                build.setResult(Result.FAILURE);
                return false;
            }
            if (cppcheckReport == null) {
                build.setResult(Result.FAILURE);
                return false;
            }
            CppcheckHealthReportThresholds cppcheckHealthReportThresholds = new CppcheckHealthReportThresholds(this.threshold, this.newThreshold, this.failureThreshold, this.newFailureThreshold, this.healthy, this.unHealthy, this.thresholdLimit);
            CppcheckResult result = new CppcheckResult(cppcheckReport, build);
            CppcheckBuildAction buildAction = new CppcheckBuildAction(build, result, cppcheckHealthReportThresholds);
            build.addAction((Action)buildAction);
            Result buildResult = new CppcheckBuildResultEvaluator().evaluateBuildResult(listener, buildAction.getNumberErrors(this.thresholdLimit, false), buildAction.getNumberErrors(this.thresholdLimit, true), cppcheckHealthReportThresholds);
            if (buildResult != Result.SUCCESS) {
                build.setResult(buildResult);
            }
            Messages.log(listener, "End of the cppcheck analysis.");
        }
        return true;
    }

    public String getCppcheckReportPattern() {
        return this.cppcheckReportPattern;
    }

    public String getThreshold() {
        return this.threshold;
    }

    public String getNewThreshold() {
        return this.newThreshold;
    }

    public String getFailureThreshold() {
        return this.failureThreshold;
    }

    public String getNewFailureThreshold() {
        return this.newFailureThreshold;
    }

    public String getHealthy() {
        return this.healthy;
    }

    public String getUnHealthy() {
        return this.unHealthy;
    }

    public String getThresholdLimit() {
        return this.thresholdLimit;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class CppcheckDescriptor
    extends BuildStepDescriptor<Publisher> {
        public CppcheckDescriptor() {
            super(CppcheckPublisher.class);
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return FreeStyleProject.class.isAssignableFrom(jobType) || MatrixProject.class.isAssignableFrom(jobType);
        }

        public String getDisplayName() {
            return "Publish Cppcheck results";
        }

        public final String getHelpFile() {
            return this.getPluginRoot() + "help.html";
        }

        public String getPluginRoot() {
            return "/plugin/cppcheck/";
        }
    }
}

