/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.cppcheck;

import com.thalesgroup.hudson.plugins.cppcheck.CppcheckResult;
import com.thalesgroup.hudson.plugins.cppcheck.util.Messages;

public class CppcheckSummary {
    private CppcheckSummary() {
    }

    public static String createReportSummary(CppcheckResult result) {
        StringBuilder summary = new StringBuilder();
        int nbErrors = result.getReport().getNumberTotal();
        summary.append(Messages.getMessage("cppcheck.Errors_ProjectAction_Name", new Object[0]));
        summary.append(": ");
        if (nbErrors == 0) {
            summary.append(Messages.getMessage("cppcheck.ResultAction.NoError", new Object[0]));
        } else {
            summary.append("<a href=\"cppcheckResult\">");
            if (nbErrors == 1) {
                summary.append(Messages.getMessage("cppcheck.ResultAction.OneError", new Object[0]));
            } else {
                summary.append(Messages.getMessage("cppcheck.ResultAction.MultipleErrors", nbErrors));
            }
            summary.append("</a>");
        }
        summary.append(".");
        return summary.toString();
    }

    public static String createReportSummaryDetails(CppcheckResult result) {
        StringBuilder builder = new StringBuilder();
        int nbNewErrors = result.getNewNumberErrors();
        builder.append("<li>");
        if (nbNewErrors == 0) {
            builder.append(Messages.getMessage("cppcheck.ResultAction_Detail_NoNewError", new Object[0]));
        } else if (nbNewErrors == 1) {
            builder.append(Messages.getMessage("cppcheck.ResultAction_Detail_NewOneError", new Object[0]));
        } else {
            builder.append(Messages.getMessage("cppcheck.ResultAction_Detail_NewMultipleErrors", new Object[0]));
            builder.append(": ");
            builder.append(nbNewErrors);
        }
        builder.append("</li>");
        return builder.toString();
    }
}

