/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.cppcheck.parser;

import com.thalesgroup.hudson.plugins.cppcheck.CppcheckReport;
import com.thalesgroup.hudson.plugins.cppcheck.model.CppcheckFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class CppcheckParser
implements Serializable {
    private static final long serialVersionUID = 1L;

    public CppcheckReport parse(File file) throws IOException, JDOMException {
        if (file == null) {
            throw new IllegalArgumentException("File input is mandatory.");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("File input " + file.getName() + " must exist.");
        }
        CppcheckReport cppCheckReport = new CppcheckReport();
        Document document = null;
        SAXBuilder sxb = new SAXBuilder();
        FileInputStream fis = new FileInputStream(file);
        InputStreamReader isr = new InputStreamReader(fis);
        document = sxb.build((Reader)isr);
        fis.close();
        isr.close();
        Element results = document.getRootElement();
        List list = results.getChildren();
        ArrayList<CppcheckFile> everyErrors = new ArrayList<CppcheckFile>();
        ArrayList<CppcheckFile> allErrors = new ArrayList<CppcheckFile>();
        ArrayList<CppcheckFile> styleErrors = new ArrayList<CppcheckFile>();
        ArrayList<CppcheckFile> allStyleErrors = new ArrayList<CppcheckFile>();
        ArrayList<CppcheckFile> errorErrors = new ArrayList<CppcheckFile>();
        ArrayList<CppcheckFile> noCategoryErrors = new ArrayList<CppcheckFile>();
        HashMap<Integer, CppcheckFile> agregateMap = new HashMap<Integer, CppcheckFile>();
        for (int i = 0; i < list.size(); ++i) {
            Element elt = (Element)list.get(i);
            CppcheckFile cppcheckFile = new CppcheckFile();
            cppcheckFile.setKey(i + 1);
            cppcheckFile.setFileName(elt.getAttributeValue("file"));
            String lineAtr = null;
            lineAtr = elt.getAttributeValue("line");
            if (lineAtr != null) {
                cppcheckFile.setLineNumber(Integer.parseInt(lineAtr));
            }
            cppcheckFile.setCppCheckId(elt.getAttributeValue("id"));
            cppcheckFile.setSeverity(elt.getAttributeValue("severity"));
            cppcheckFile.setMessage(elt.getAttributeValue("msg"));
            if ("all".equals(cppcheckFile.getSeverity())) {
                allErrors.add(cppcheckFile);
            } else if ("style".equals(cppcheckFile.getSeverity())) {
                styleErrors.add(cppcheckFile);
            } else if ("all style".equals(cppcheckFile.getSeverity())) {
                allStyleErrors.add(cppcheckFile);
            } else if ("error".equals(cppcheckFile.getSeverity())) {
                errorErrors.add(cppcheckFile);
            } else {
                noCategoryErrors.add(cppcheckFile);
            }
            everyErrors.add(cppcheckFile);
            agregateMap.put(cppcheckFile.getKey(), cppcheckFile);
        }
        cppCheckReport.setEveryErrors(everyErrors);
        cppCheckReport.setAllErrors(allErrors);
        cppCheckReport.setStyleErrors(styleErrors);
        cppCheckReport.setAllStyleErrors(allStyleErrors);
        cppCheckReport.setErrorErrors(errorErrors);
        cppCheckReport.setNoCategoryErrors(noCategoryErrors);
        cppCheckReport.setInternalMap(agregateMap);
        return cppCheckReport;
    }
}

