/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.cppcheck.util;

import com.thalesgroup.hudson.plugins.cppcheck.CppcheckHealthReportThresholds;
import com.thalesgroup.hudson.plugins.cppcheck.util.Messages;
import hudson.model.BuildListener;
import hudson.model.Result;

public class CppcheckBuildResultEvaluator {
    private boolean isErrorCountExceeded(int errorCount, String errorThreshold) {
        if (errorCount > 0 && CppcheckHealthReportThresholds.isValid(errorThreshold)) {
            return errorCount > CppcheckHealthReportThresholds.convert(errorThreshold);
        }
        return false;
    }

    public Result evaluateBuildResult(BuildListener listener, int errorsCount, int newErrorsCount, CppcheckHealthReportThresholds cppcheckHealthReportThresholds) {
        if (this.isErrorCountExceeded(errorsCount, cppcheckHealthReportThresholds.getFailureThreshold())) {
            Messages.log(listener, "Setting build status to FAILURE since total number of errors exceeds the threshold " + cppcheckHealthReportThresholds.getFailureThreshold());
            return Result.FAILURE;
        }
        if (this.isErrorCountExceeded(newErrorsCount, cppcheckHealthReportThresholds.getNewFailureThreshold())) {
            Messages.log(listener, "Setting build status to FAILURE since total number of new errors exceeds the threshold " + cppcheckHealthReportThresholds.getNewFailureThreshold());
            return Result.FAILURE;
        }
        if (this.isErrorCountExceeded(errorsCount, cppcheckHealthReportThresholds.getThreshold())) {
            Messages.log(listener, "Setting build status to UNSTABLE since total number of errors exceeds the threshold " + cppcheckHealthReportThresholds.getThreshold());
            return Result.UNSTABLE;
        }
        if (this.isErrorCountExceeded(newErrorsCount, cppcheckHealthReportThresholds.getNewThreshold())) {
            Messages.log(listener, "Setting build status to UNSTABLE since total number of new errors exceeds the threshold " + cppcheckHealthReportThresholds.getNewThreshold());
            return Result.UNSTABLE;
        }
        Messages.log(listener, "Not changing build status, since no threshold has been exceeded");
        return Result.SUCCESS;
    }
}

