/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.cppcheck;

import java.io.Serializable;
import org.apache.commons.lang.StringUtils;

public class CppcheckHealthReportThresholds
implements Serializable {
    private final String threshold;
    private final String newThreshold;
    private final String failureThreshold;
    private final String newFailureThreshold;
    private final String healthy;
    private final String unHealthy;
    private final String thresholdLimit;

    public CppcheckHealthReportThresholds(String threshold, String newThreshold, String failureThreshold, String newFailureThreshold, String healthy, String unHealthy, String thresholdLimit) {
        this.threshold = threshold;
        this.newThreshold = newThreshold;
        this.failureThreshold = failureThreshold;
        this.newFailureThreshold = newFailureThreshold;
        this.healthy = healthy;
        this.unHealthy = unHealthy;
        this.thresholdLimit = thresholdLimit;
    }

    public String getThreshold() {
        return this.threshold;
    }

    public String getNewThreshold() {
        return this.newThreshold;
    }

    public String getFailureThreshold() {
        return this.failureThreshold;
    }

    public String getNewFailureThreshold() {
        return this.newFailureThreshold;
    }

    public String getHealthy() {
        return this.healthy;
    }

    public String getUnHealthy() {
        return this.unHealthy;
    }

    public String getThresholdLimit() {
        return this.thresholdLimit;
    }

    public static int convert(String threshold) {
        if (CppcheckHealthReportThresholds.isValid(threshold) && StringUtils.isNotBlank((String)threshold)) {
            try {
                return Integer.valueOf(threshold);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new IllegalArgumentException("Not a parsable integer value >= 0: " + threshold);
    }

    public static boolean isValid(String threshold) {
        if (StringUtils.isNotBlank((String)threshold)) {
            try {
                return Integer.valueOf(threshold) >= 0;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }
}

